/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;

public class NodePropertyExistenceConstraintRule
extends NodePropertyConstraintRule {
    private final int propertyKeyId;

    public static NodePropertyExistenceConstraintRule nodePropertyExistenceConstraintRule(long id, int labelId, int propertyKeyId) {
        return new NodePropertyExistenceConstraintRule(id, labelId, propertyKeyId);
    }

    public static NodePropertyExistenceConstraintRule readNodePropertyExistenceConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new NodePropertyExistenceConstraintRule(id, labelId, NodePropertyExistenceConstraintRule.readPropertyKey(buffer));
    }

    private NodePropertyExistenceConstraintRule(long id, int labelId, int propertyKeyId) {
        super(id, labelId, SchemaRule.Kind.NODE_PROPERTY_EXISTENCE_CONSTRAINT);
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public String toString() {
        return "NodePropertyExistenceConstraintRule[id=" + this.id + ", label=" + this.label + ", kind=" + (Object)((Object)this.kind) + ", propertyKeyId=" + this.propertyKeyId + "]";
    }

    @Override
    public int length() {
        return 9;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.label);
        target.put(this.kind.id());
        target.putInt(this.propertyKeyId);
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public int getPropertyKey() {
        return this.propertyKeyId;
    }

    @Override
    public NodePropertyConstraint toConstraint() {
        return new NodePropertyExistenceConstraint(this.getLabel(), this.getPropertyKey());
    }

    @Override
    public boolean containsPropertyKeyId(int propertyKeyId) {
        return propertyKeyId == this.propertyKeyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.propertyKeyId == ((NodePropertyExistenceConstraintRule)o).propertyKeyId;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.propertyKeyId;
    }
}

