/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.coreapi.AbstractAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProvider;

public class NodeAutoIndexerImpl
extends AbstractAutoIndexerImpl<Node> {
    static final String NODE_AUTO_INDEX = "node_auto_index";
    private Config config;
    private IndexProvider indexProvider;
    private NodeManager nodeManager;

    public NodeAutoIndexerImpl(Config config, IndexProvider indexProvider, NodeManager nodeManager) {
        this.config = config;
        this.indexProvider = indexProvider;
        this.nodeManager = nodeManager;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() {
        this.setEnabled(this.config.get(Configuration.node_auto_indexing));
        this.propertyKeysToInclude.addAll(this.parseConfigList(this.config.get(Configuration.node_keys_indexable)));
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    protected Index<Node> getIndexInternal() {
        return this.indexProvider.getOrCreateNodeIndex(NODE_AUTO_INDEX, null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.nodeManager.addNodePropertyTracker(this);
        } else {
            this.nodeManager.removeNodePropertyTracker(this);
        }
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> node_auto_indexing = GraphDatabaseSettings.node_auto_indexing;
        public static final Setting<String> node_keys_indexable = GraphDatabaseSettings.node_keys_indexable;
    }
}

