/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.kernel.impl.coreapi.LegacyIndexProxy;
import org.neo4j.kernel.impl.coreapi.RelationshipLegacyIndexProxy;

public class IndexProviderImpl
implements IndexProvider {
    private final LegacyIndexProxy.Lookup lookup;
    private final ThreadToStatementContextBridge transactionBridge;

    public IndexProviderImpl(LegacyIndexProxy.Lookup lookup, ThreadToStatementContextBridge transactionBridge) {
        this.lookup = lookup;
        this.transactionBridge = transactionBridge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Index<Node> getOrCreateNodeIndex(String indexName, Map<String, String> customConfiguration) {
        try (Statement statement = this.transactionBridge.get();){
            statement.dataWriteOperations().nodeLegacyIndexCreateLazily(indexName, customConfiguration);
            LegacyIndexProxy<Node> legacyIndexProxy = new LegacyIndexProxy<Node>(indexName, LegacyIndexProxy.Type.NODE, this.lookup, this.transactionBridge);
            return legacyIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelationshipIndex getOrCreateRelationshipIndex(String indexName, Map<String, String> customConfiguration) {
        try (Statement statement = this.transactionBridge.get();){
            statement.dataWriteOperations().relationshipLegacyIndexCreateLazily(indexName, customConfiguration);
            RelationshipLegacyIndexProxy relationshipLegacyIndexProxy = new RelationshipLegacyIndexProxy(indexName, this.lookup, this.transactionBridge);
            return relationshipLegacyIndexProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }
}

