/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;

public class AlreadyConstrainedException
extends SchemaKernelException {
    private static final String NO_CONTEXT_FORMAT = "Already constrained %s.";
    private static final String ALREADY_CONSTRAINED_MESSAGE_PREFIX = "Constraint already exists: ";
    private static final String INDEX_CONTEXT_FORMAT = "Label '%s' and property '%s' have a unique constraint defined on them, so an index is already created that matches this.";
    private final PropertyConstraint constraint;
    private final SchemaKernelException.OperationContext context;

    public AlreadyConstrainedException(PropertyConstraint constraint, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super(Status.Schema.ConstraintAlreadyExists, AlreadyConstrainedException.constructUserMessage(context, tokenNameLookup, constraint));
        this.constraint = constraint;
        this.context = context;
    }

    public PropertyConstraint constraint() {
        return this.constraint;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, PropertyConstraint constraint) {
        switch (context) {
            case INDEX_CREATION: {
                NodePropertyConstraint nodePropertyConstraint = (NodePropertyConstraint)constraint;
                return AlreadyConstrainedException.messageWithLabelAndPropertyName(tokenNameLookup, INDEX_CONTEXT_FORMAT, nodePropertyConstraint.label(), nodePropertyConstraint.propertyKey());
            }
            case CONSTRAINT_CREATION: {
                return ALREADY_CONSTRAINED_MESSAGE_PREFIX + constraint.userDescription(tokenNameLookup);
            }
        }
        return String.format(NO_CONTEXT_FORMAT, constraint);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return AlreadyConstrainedException.constructUserMessage(this.context, tokenNameLookup, this.constraint);
    }
}

