/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.logging.Log;

public class KernelHealth {
    private static final String panicMessage = "Kernel has encountered some problem, please perform necessary action (tx recovery/restart)";
    private volatile boolean tmOk = true;
    private final KernelPanicEventGenerator kpe;
    private final Log log;
    private Throwable causeOfPanic;

    public KernelHealth(KernelPanicEventGenerator kpe, Log log) {
        this.kpe = kpe;
        this.log = log;
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (!this.tmOk) {
            Throwable exception;
            try {
                try {
                    exception = (Throwable)panicDisguise.getConstructor(String.class, Throwable.class).newInstance(panicMessage, this.causeOfPanic);
                }
                catch (NoSuchMethodException e) {
                    exception = Exceptions.withCause((Throwable)panicDisguise.getConstructor(String.class).newInstance(panicMessage), this.causeOfPanic);
                }
            }
            catch (Exception e) {
                throw new Error("Kernel has encountered some problem, please perform necessary action (tx recovery/restart). An exception of type " + panicDisguise.getName() + " was requested to be thrown but that proved impossible", e);
            }
            throw exception;
        }
    }

    public void panic(Throwable cause) {
        if (!this.tmOk) {
            return;
        }
        if (cause == null) {
            throw new IllegalArgumentException("Must provide a cause for the kernel panic");
        }
        this.causeOfPanic = cause;
        this.tmOk = false;
        this.log.error("setting TM not OK. Kernel has encountered some problem, please perform necessary action (tx recovery/restart)", cause);
        this.kpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK, this.causeOfPanic);
    }

    public boolean isHealthy() {
        return this.tmOk;
    }

    public Throwable getCauseOfPanic() {
        if (this.tmOk) {
            throw new IllegalStateException("Kernel is healthy, no panic cause found");
        }
        return this.causeOfPanic;
    }

    public void healed() {
        this.tmOk = true;
        this.causeOfPanic = null;
        this.log.info("Kernel health set to OK");
    }
}

