/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public interface RecordStore<R extends AbstractBaseRecord>
extends IdSequence {
    public File getStorageFileName();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public R getRecord(long var1);

    public Collection<R> getRecords(long var1);

    public void updateRecord(R var1);

    public R forceGetRecord(long var1);

    public void forceUpdateRecord(R var1);

    public <FAILURE extends Exception> void accept(Processor<FAILURE> var1, R var2) throws FAILURE;

    public int getRecordSize();

    public int getRecordHeaderSize();

    public int getRecordsPerPage();

    public void close();

    public void flush();

    public int getNumberOfReservedLowIds();

    public static class Scanner {
        @SafeVarargs
        public static <R extends AbstractBaseRecord> Iterable<R> scan(RecordStore<R> store, Predicate<? super R> ... filters) {
            return Scanner.scan(store, true, filters);
        }

        @SafeVarargs
        public static <R extends AbstractBaseRecord> Iterable<R> scan(final RecordStore<R> store, final boolean forward, final Predicate<? super R> ... filters) {
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new PrefetchingIterator<R>(){
                        final PrimitiveLongIterator ids;
                        {
                            this.ids = new StoreIdIterator(store, forward);
                        }

                        @Override
                        protected R fetchNextOrNull() {
                            block0: while (this.ids.hasNext()) {
                                Object record = store.forceGetRecord(this.ids.next());
                                if (!((AbstractBaseRecord)record).inUse()) continue;
                                for (Predicate filter : filters) {
                                    if (!filter.test(record)) continue block0;
                                }
                                return record;
                            }
                            return null;
                        }
                    };
                }
            };
        }
    }

    public static abstract class Processor<FAILURE extends Exception> {
        private volatile boolean shouldStop;

        public void stop() {
            this.shouldStop = true;
        }

        public abstract void processSchema(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processNode(RecordStore<NodeRecord> var1, NodeRecord var2) throws FAILURE;

        public abstract void processRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2) throws FAILURE;

        public abstract void processProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2) throws FAILURE;

        public abstract void processString(RecordStore<DynamicRecord> var1, DynamicRecord var2, IdType var3) throws FAILURE;

        public abstract void processArray(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processLabelArrayWithOwner(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2) throws FAILURE;

        public abstract void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2) throws FAILURE;

        public abstract void processLabelToken(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2) throws FAILURE;

        public abstract void processRelationshipGroup(RecordStore<RelationshipGroupRecord> var1, RelationshipGroupRecord var2) throws FAILURE;

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, ProgressListener.NONE, filters);
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, progressListener, filters);
        }

        private <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            for (AbstractBaseRecord record : Scanner.scan(store, true, filters)) {
                if (this.shouldStop) break;
                store.accept(this, record);
                progressListener.set(record.getLongId());
            }
            progressListener.done();
        }
    }

    public static class Delegator<R extends AbstractBaseRecord>
    implements RecordStore<R> {
        private final RecordStore<R> actual;

        public Delegator(RecordStore<R> actual) {
            this.actual = actual;
        }

        @Override
        public long nextId() {
            return this.actual.nextId();
        }

        @Override
        public File getStorageFileName() {
            return this.actual.getStorageFileName();
        }

        @Override
        public long getHighId() {
            return this.actual.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.actual.getHighestPossibleIdInUse();
        }

        @Override
        public R getRecord(long id) {
            return this.actual.getRecord(id);
        }

        @Override
        public Collection<R> getRecords(long id) {
            return this.actual.getRecords(id);
        }

        @Override
        public void updateRecord(R record) {
            this.actual.updateRecord(record);
        }

        @Override
        public R forceGetRecord(long id) {
            return this.actual.forceGetRecord(id);
        }

        @Override
        public void forceUpdateRecord(R record) {
            this.actual.forceUpdateRecord(record);
        }

        @Override
        public <FAILURE extends Exception> void accept(Processor<FAILURE> processor, R record) throws FAILURE {
            this.actual.accept(processor, record);
        }

        @Override
        public int getRecordSize() {
            return this.actual.getRecordSize();
        }

        @Override
        public int getRecordHeaderSize() {
            return this.actual.getRecordHeaderSize();
        }

        @Override
        public int getRecordsPerPage() {
            return this.actual.getRecordsPerPage();
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public int getNumberOfReservedLowIds() {
            return this.actual.getNumberOfReservedLowIds();
        }

        @Override
        public void flush() {
            this.actual.flush();
        }
    }
}

