/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collections;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.register.Register;

public interface IndexReader
extends Resource {
    public static final IndexReader EMPTY = new IndexReader(){

        @Override
        public PrimitiveLongIterator seek(Object value) {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public PrimitiveLongIterator scan() {
            return PrimitiveLongCollections.emptyIterator();
        }

        @Override
        public int countIndexedNodes(long nodeId, Object propertyValue) {
            return 0;
        }

        @Override
        public Set<Class> valueTypesInIndex() {
            return Collections.emptySet();
        }

        @Override
        public long sampleIndex(Register.DoubleLong.Out result) {
            result.write(0L, 0L);
            return 0L;
        }

        @Override
        public void close() {
        }
    };

    public PrimitiveLongIterator seek(Object var1);

    public PrimitiveLongIterator rangeSeekByNumberInclusive(Number var1, Number var2);

    public PrimitiveLongIterator rangeSeekByString(String var1, boolean var2, String var3, boolean var4);

    public PrimitiveLongIterator rangeSeekByPrefix(String var1);

    public PrimitiveLongIterator scan();

    public int countIndexedNodes(long var1, Object var3);

    public Set<Class> valueTypesInIndex();

    public long sampleIndex(Register.DoubleLong.Out var1) throws IndexNotFoundKernelException;

    public static class Delegator
    implements IndexReader {
        private final IndexReader delegate;

        public Delegator(IndexReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public PrimitiveLongIterator seek(Object value) {
            return this.delegate.seek(value);
        }

        @Override
        public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
            return this.delegate.rangeSeekByNumberInclusive(lower, upper);
        }

        @Override
        public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
            return this.delegate.rangeSeekByString(lower, includeLower, upper, includeUpper);
        }

        @Override
        public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
            return this.delegate.rangeSeekByPrefix(prefix);
        }

        @Override
        public PrimitiveLongIterator scan() {
            return this.delegate.scan();
        }

        @Override
        public int countIndexedNodes(long nodeId, Object propertyValue) {
            return this.delegate.countIndexedNodes(nodeId, propertyValue);
        }

        @Override
        public Set<Class> valueTypesInIndex() {
            return this.delegate.valueTypesInIndex();
        }

        @Override
        public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
            return this.delegate.sampleIndex(result);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

