/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.info.DiagnosticsManager;

public abstract class EditionModule {
    public IdGeneratorFactory idGeneratorFactory;
    public LabelTokenHolder labelTokenHolder;
    public PropertyKeyTokenHolder propertyKeyTokenHolder;
    public Locks lockManager;
    public CommitProcessFactory commitProcessFactory;
    public long transactionStartTimeout;
    public RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    public TransactionHeaderInformationFactory headerInformationFactory;
    public SchemaWriteGuard schemaWriteGuard;
    public UpgradeConfiguration upgradeConfiguration;
    public ConstraintSemantics constraintSemantics;

    protected void doAfterRecoveryAndStartup(String editionName, DependencyResolver dependencyResolver) {
        DiagnosticsManager diagnosticsManager = dependencyResolver.resolveDependency(DiagnosticsManager.class);
        NeoStoreDataSource neoStoreDataSource = dependencyResolver.resolveDependency(NeoStoreDataSource.class);
        diagnosticsManager.prependProvider(new KernelDiagnostics.Versions(editionName, neoStoreDataSource.get().getMetaDataStore().getStoreId()));
        neoStoreDataSource.registerDiagnosticsWith(diagnosticsManager);
        diagnosticsManager.appendProvider(new KernelDiagnostics.StoreFiles(neoStoreDataSource.getStoreDir()));
    }
}

