/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.procedures;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.Neo4jTypes;

public class ProcedureSignature {
    private final ProcedureName name;
    private final List<ArgumentSignature> inputSignature;
    private final List<ArgumentSignature> outputSignature;

    public ProcedureSignature(ProcedureName name, List<ArgumentSignature> inputSignature, List<ArgumentSignature> outputSignature) {
        this.name = name;
        this.inputSignature = inputSignature;
        this.outputSignature = outputSignature;
    }

    public ProcedureSignature(ProcedureName name) {
        this(name, null, null);
    }

    public ProcedureName name() {
        return this.name;
    }

    public List<ArgumentSignature> inputSignature() {
        return this.inputSignature;
    }

    public List<ArgumentSignature> outputSignature() {
        return this.outputSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureSignature that = (ProcedureSignature)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.inputSignature != null ? !this.inputSignature.equals(that.inputSignature) : that.inputSignature != null) {
            return false;
        }
        return !(this.outputSignature == null ? that.outputSignature != null : !this.outputSignature.equals(that.outputSignature));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig = this.inputSignature == null ? "..." : Iterables.toString(ProcedureSignature.typesOf(this.inputSignature), ", ");
        String strOutSig = this.outputSignature == null ? "..." : Iterables.toString(ProcedureSignature.typesOf(this.outputSignature), ", ");
        return String.format("%s(%s) : (%s)", this.name, strInSig, strOutSig);
    }

    public static Builder procedureSignature(String ... namespaceAndName) {
        String[] namespace = namespaceAndName.length > 1 ? Arrays.copyOf(namespaceAndName, namespaceAndName.length - 1) : new String[]{};
        String name = namespaceAndName[namespaceAndName.length - 1];
        return ProcedureSignature.procedureSignature(namespace, name);
    }

    public static Builder procedureSignature(String[] namespace, String name) {
        return new Builder(namespace, name);
    }

    private static List<Neo4jTypes.AnyType> typesOf(List<ArgumentSignature> namedSig) {
        LinkedList<Neo4jTypes.AnyType> out = new LinkedList<Neo4jTypes.AnyType>();
        for (int i = 0; i < namedSig.size(); ++i) {
            out.add(namedSig.get(i).neo4jType());
        }
        return out;
    }

    public static class Builder {
        private final ProcedureName name;
        private final List<ArgumentSignature> inputSignature = new LinkedList<ArgumentSignature>();
        private final List<ArgumentSignature> outputSignature = new LinkedList<ArgumentSignature>();

        public Builder(String[] namespace, String name) {
            this.name = new ProcedureName(namespace, name);
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(new ArgumentSignature(name, type));
            return this;
        }

        public Builder out(String name, Neo4jTypes.AnyType type) {
            this.outputSignature.add(new ArgumentSignature(name, type));
            return this;
        }

        public ProcedureSignature build() {
            return new ProcedureSignature(this.name, this.inputSignature, this.outputSignature);
        }
    }

    public static class ArgumentSignature {
        private final String name;
        private final Neo4jTypes.AnyType type;

        public ArgumentSignature(String name, Neo4jTypes.AnyType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public Neo4jTypes.AnyType neo4jType() {
            return this.type;
        }
    }

    public static class ProcedureName {
        private final String[] namespace;
        private final String name;

        public ProcedureName(List<String> namespace, String name) {
            this(namespace.toArray(new String[namespace.size()]), name);
        }

        public ProcedureName(String[] namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String[] namespace() {
            return this.namespace;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            String strNamespace = this.namespace.length > 0 ? Iterables.toString(Arrays.asList(this.namespace), ".") + "." : "";
            return String.format("%s%s", strNamespace, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcedureName that = (ProcedureName)o;
            if (!Arrays.equals(this.namespace, that.namespace)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.namespace);
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

