/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class Legacy21Store
implements LegacyStore {
    public static final String LEGACY_VERSION = "v0.A.3";
    private final File storageFileName;

    public Legacy21Store(File storageFileName) throws IOException {
        this.storageFileName = storageFileName;
        Legacy21Store.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.6");
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    @Override
    public File getStorageFileName() {
        return this.storageFileName;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LegacyNodeStoreReader getNodeStoreReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LegacyRelationshipStoreReader getRelStoreReader() {
        throw new UnsupportedOperationException();
    }
}

