/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;

public class IndexDefineCommand
extends Command {
    static final int HIGHEST_POSSIBLE_ID = 65534;
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private Map<String, Integer> indexNameIdRange;
    private Map<String, Integer> keyIdRange;
    private PrimitiveIntObjectMap<String> idToIndexName;
    private PrimitiveIntObjectMap<String> idToKey;

    public IndexDefineCommand() {
        this.setIndexNameIdRange(new HashMap<String, Integer>());
        this.setKeyIdRange(new HashMap<String, Integer>());
        this.idToIndexName = Primitive.intObjectMap((int)16);
        this.idToKey = Primitive.intObjectMap((int)16);
    }

    public void init(Map<String, Integer> indexNames, Map<String, Integer> keys) {
        this.setIndexNameIdRange(indexNames);
        this.setKeyIdRange(keys);
        this.idToIndexName = IndexDefineCommand.reverse(indexNames);
        this.idToKey = IndexDefineCommand.reverse(keys);
    }

    private static PrimitiveIntObjectMap<String> reverse(Map<String, Integer> map) {
        PrimitiveIntObjectMap result = Primitive.intObjectMap((int)map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            result.put(entry.getValue().intValue(), (Object)entry.getKey());
        }
        return result;
    }

    private static String getFromMap(PrimitiveIntObjectMap<String> map, int id) {
        if (id == -1) {
            return null;
        }
        String result = (String)map.get(id);
        if (result == null) {
            throw new IllegalArgumentException("" + id);
        }
        return result;
    }

    public String getIndexName(int id) {
        return IndexDefineCommand.getFromMap(this.idToIndexName, id);
    }

    public String getKey(int id) {
        return IndexDefineCommand.getFromMap(this.idToKey, id);
    }

    public int getOrAssignIndexNameId(String indexName) {
        return this.getOrAssignId(this.indexNameIdRange, this.idToIndexName, this.nextIndexNameId, indexName);
    }

    public int getOrAssignKeyId(String key) {
        return this.getOrAssignId(this.keyIdRange, this.idToKey, this.nextKeyId, key);
    }

    private int getOrAssignId(Map<String, Integer> stringToId, PrimitiveIntObjectMap<String> idToString, AtomicInteger nextId, String string) {
        if (string == null) {
            return -1;
        }
        Integer id = stringToId.get(string);
        if (id != null) {
            return id;
        }
        int nextIdInt = nextId.incrementAndGet();
        if (nextIdInt > 65534) {
            throw new IllegalStateException(String.format("Modifying more than %d indexes in a single transaction is not supported", 65535));
        }
        id = nextIdInt;
        stringToId.put(string, id);
        idToString.put(id.intValue(), (Object)string);
        return id;
    }

    @Override
    public int hashCode() {
        int result = this.nextIndexNameId != null ? this.nextIndexNameId.hashCode() : 0;
        result = 31 * result + (this.nextKeyId != null ? this.nextKeyId.hashCode() : 0);
        result = 31 * result + (this.getIndexNameIdRange() != null ? this.getIndexNameIdRange().hashCode() : 0);
        result = 31 * result + (this.getKeyIdRange() != null ? this.getKeyIdRange().hashCode() : 0);
        result = 31 * result + (this.idToIndexName != null ? this.idToIndexName.hashCode() : 0);
        result = 31 * result + (this.idToKey != null ? this.idToKey.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        IndexDefineCommand other = (IndexDefineCommand)obj;
        return this.getIndexNameIdRange().equals(other.getIndexNameIdRange()) && this.getKeyIdRange().equals(other.getKeyIdRange());
    }

    @Override
    public boolean handle(CommandHandler visitor) throws IOException {
        return visitor.visitIndexDefineCommand(this);
    }

    public Map<String, Integer> getIndexNameIdRange() {
        return this.indexNameIdRange;
    }

    public void setIndexNameIdRange(Map<String, Integer> indexNameIdRange) {
        this.indexNameIdRange = indexNameIdRange;
    }

    public Map<String, Integer> getKeyIdRange() {
        return this.keyIdRange;
    }

    public void setKeyIdRange(Map<String, Integer> keyIdRange) {
        this.keyIdRange = keyIdRange;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[names:" + this.indexNameIdRange + ", keys:" + this.keyIdRange + "]";
    }
}

