/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.Comparator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.SingleNodePath;

public abstract class Sorting {
    private Sorting() {
    }

    public static Comparator<? super Path> endNodeProperty(final String propertyKey) {
        return new EndNodeComparator(){

            @Override
            protected int compareNodes(Node endNode1, Node endNode2) {
                Comparable p2;
                Comparable p1 = (Comparable)endNode1.getProperty(propertyKey);
                if (p1 == (p2 = (Comparable)endNode2.getProperty(propertyKey))) {
                    return 0;
                }
                if (p1 == null) {
                    return Integer.MIN_VALUE;
                }
                if (p2 == null) {
                    return Integer.MAX_VALUE;
                }
                return p1.compareTo(p2);
            }
        };
    }

    public static Comparator<? super Path> endNodeRelationshipCount(final PathExpander expander) {
        return new EndNodeComparator(){

            @Override
            protected int compareNodes(Node endNode1, Node endNode2) {
                Integer count1 = this.count(endNode1, expander);
                Integer count2 = this.count(endNode2, expander);
                return count1.compareTo(count2);
            }

            private Integer count(Node node, PathExpander expander2) {
                return IteratorUtil.count(expander2.expand(new SingleNodePath(node), BranchState.NO_STATE));
            }
        };
    }

    private static abstract class EndNodeComparator
    implements Comparator<Path> {
        private EndNodeComparator() {
        }

        @Override
        public int compare(Path p1, Path p2) {
            return this.compareNodes(p1.endNode(), p2.endNode());
        }

        protected abstract int compareNodes(Node var1, Node var2);
    }
}

