/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;

public class NeoStoreTransactionApplier
extends CommandHandler.Adapter {
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final LockGroup lockGroup;
    private final long transactionId;

    public NeoStoreTransactionApplier(NeoStores store, CacheAccessBackDoor cacheAccess, LockService lockService, LockGroup lockGroup, long transactionId) {
        this.neoStores = store;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
        this.transactionId = transactionId;
        this.lockGroup = lockGroup;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        NodeStore nodeStore = this.neoStores.getNodeStore();
        nodeStore.updateRecord(command.getAfter());
        nodeStore.updateDynamicLabelRecords(command.getAfter().getDynamicLabelRecords());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        RelationshipRecord record = command.getRecord();
        this.neoStores.getRelationshipStore().updateRecord(record);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        long nodeId = command.getNodeId();
        if (nodeId != -1L) {
            this.lockGroup.add(this.lockService.acquireNodeLock(nodeId, LockService.LockType.WRITE_LOCK));
        }
        this.neoStores.getPropertyStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.neoStores.getRelationshipGroupStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.neoStores.getRelationshipTypeTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.neoStores.getLabelTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.neoStores.getPropertyKeyTokenStore().updateRecord(command.getRecord());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            schemaStore.updateRecord(record);
        }
        if (command.getSchemaRule() instanceof PropertyConstraintRule) {
            switch (command.getMode()) {
                case UPDATE: 
                case CREATE: {
                    this.neoStores.getMetaDataStore().setLatestConstraintIntroducingTx(this.transactionId);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        switch (command.getMode()) {
            case DELETE: {
                this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                break;
            }
            default: {
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
        }
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.neoStores.getMetaDataStore().setGraphNextProp(command.getRecord().getNextProp());
        return false;
    }
}

