/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class SchemaIndexMigrator
implements StoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final StoreFactory storeFactory;

    public SchemaIndexMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, StoreFactory storeFactory) {
        this.fileSystem = fileSystem;
        this.storeFactory = storeFactory;
        storeFactory.setConfig(new Config());
        storeFactory.setFileSystemAbstraction(fileSystem);
        storeFactory.setIdGeneratorFactory(new DefaultIdGeneratorFactory(fileSystem));
        storeFactory.setLogProvider((LogProvider)NullLogProvider.getInstance());
        storeFactory.setPageCache(pageCache);
    }

    @Override
    public void migrate(File storeDir, File migrationDir, SchemaIndexProvider schemaIndexProvider, String versionToMigrateFrom) throws IOException {
        switch (versionToMigrateFrom) {
            case "v0.A.0": {
                break;
            }
            case "v0.A.1": 
            case "v0.A.3": {
                this.deleteIndexesContainingArrayValues(storeDir, schemaIndexProvider);
                break;
            }
            case "v0.A.5": {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + versionToMigrateFrom);
            }
        }
    }

    private void deleteIndexesContainingArrayValues(File storeDir, SchemaIndexProvider schemaIndexProvider) throws IOException {
        File indexRoot = SchemaIndexProvider.getRootDirectory(storeDir, schemaIndexProvider.getProviderDescriptor().getKey());
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(new Config());
        ArrayList<File> indexesToBeDeleted = new ArrayList<File>();
        this.storeFactory.setStoreDir(storeDir);
        try (NeoStores neoStores = this.storeFactory.openNeoStores(2);){
            SchemaStore schema = neoStores.getSchemaStore();
            Iterator<SchemaRule> rules = schema.loadAllSchemaRules();
            while (rules.hasNext()) {
                SchemaRule rule = rules.next();
                IndexConfiguration indexConfig = new IndexConfiguration(rule.getKind() == SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
                IndexAccessor accessor = schemaIndexProvider.getOnlineAccessor(rule.getId(), indexConfig, samplingConfig);
                Throwable throwable = null;
                try {
                    IndexReader reader = accessor.newReader();
                    Throwable throwable2 = null;
                    try {
                        if (!reader.valueTypesInIndex().contains(Array.class)) continue;
                        indexesToBeDeleted.add(new File(indexRoot, "" + rule.getId()));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (accessor == null) continue;
                    if (throwable != null) {
                        try {
                            accessor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    accessor.close();
                }
            }
        }
        for (File index : indexesToBeDeleted) {
            this.fileSystem.deleteRecursively(index);
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom) throws IOException {
    }

    @Override
    public void rebuildCounts(File storeDir, String versionToMigrateFrom) throws IOException {
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
    }
}

