/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.logging.LogProvider;

public class NodeStore
extends AbstractRecordStore<NodeRecord> {
    public static final String TYPE_DESCRIPTOR = "NodeStore";
    public static final int RECORD_SIZE = 15;
    private final DynamicArrayStore dynamicLabelStore;

    public static Long readOwnerFromDynamicLabelsRecord(DynamicRecord record) {
        byte[] data = record.getData();
        byte[] header = PropertyType.ARRAY.readDynamicRecordHeader(data);
        byte[] array = Arrays.copyOfRange(data, header.length, data.length);
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return null;
        }
        Bits bits = Bits.bitsFromBytes(array);
        return bits.getLong(requiredBits);
    }

    public NodeStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicArrayStore dynamicLabelStore) {
        super(fileName, config, IdType.NODE, idGeneratorFactory, pageCache, logProvider);
        this.dynamicLabelStore = dynamicLabelStore;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, NodeRecord record) throws FAILURE {
        processor.processNode(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 15;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    public void ensureHeavy(NodeRecord node) {
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField())) {
            this.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()));
        }
    }

    public void ensureHeavy(NodeRecord node, long firstDynamicLabelRecord) {
        if (!node.isLight()) {
            return;
        }
        node.setLabelField(node.getLabelField(), this.dynamicLabelStore.getRecords(firstDynamicLabelRecord));
    }

    @Override
    public NodeRecord getRecord(long id) {
        return this.getRecord(id, null);
    }

    public NodeRecord getRecord(long id, NodeRecord record) {
        NodeRecord result = this.loadRecord(id, record);
        if (result == null) {
            throw new InvalidRecordException("NodeRecord[" + id + "] not in use");
        }
        return result;
    }

    public NodeRecord loadLightNode(long id) {
        return this.loadRecord(id, null);
    }

    @Override
    public NodeRecord forceGetRecord(long id) {
        NodeRecord record = this.loadRecord(id, null);
        if (record == null) {
            return new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeRecord loadRecord(long id, NodeRecord record) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            boolean isInUse = false;
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    byte inUseByte = cursor.getByte();
                    isInUse = this.isInUse(inUseByte);
                    if (!isInUse) continue;
                    if (record == null) {
                        record = new NodeRecord(id);
                    }
                    record.setId(id);
                    this.readIntoRecord(cursor, record, inUseByte, true);
                } while (cursor.shouldRetry());
            }
            NodeRecord nodeRecord = isInUse ? record : null;
            return nodeRecord;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void forceUpdateRecord(NodeRecord record) {
        this.writeRecord(record, true);
    }

    @Override
    public void updateRecord(NodeRecord record) {
        this.writeRecord(record, false);
        if (!record.inUse()) {
            this.freeId(record.getId());
        }
    }

    private void writeRecord(NodeRecord record, boolean force) {
        long recordId = record.getId();
        long pageId = this.pageIdForRecord(recordId);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                do {
                    this.writeRecord(cursor, record, force);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void writeRecord(PageCursor cursor, NodeRecord record, boolean force) {
        int offset = this.offsetForId(record.getId());
        cursor.setOffset(offset);
        if (record.inUse() || force) {
            long nextRel = record.getNextRel();
            long nextProp = record.getNextProp();
            short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
            int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
            short inUseUnsignedByte = (record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue();
            inUseUnsignedByte = (short)(inUseUnsignedByte | relModifier | propModifier);
            cursor.putByte((byte)inUseUnsignedByte);
            cursor.putInt((int)nextRel);
            cursor.putInt((int)nextProp);
            long labelField = record.getLabelField();
            cursor.putInt((int)labelField);
            cursor.putByte((byte)((labelField & 0xFF00000000L) >> 32));
            byte extra = record.isDense() ? (byte)1 : 0;
            cursor.putByte(extra);
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inUse(long id) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            boolean recordIsInUse = false;
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    recordIsInUse = this.isInUse(cursor.getByte());
                } while (cursor.shouldRetry());
            }
            boolean bl = recordIsInUse;
            return bl;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void readIntoRecord(PageCursor cursor, NodeRecord record, byte inUseByte, boolean inUse) {
        long nextRel = cursor.getUnsignedInt();
        long nextProp = cursor.getUnsignedInt();
        long relModifier = ((long)inUseByte & 0xEL) << 31;
        long propModifier = ((long)inUseByte & 0xF0L) << 28;
        long lsbLabels = cursor.getUnsignedInt();
        long hsbLabels = cursor.getByte() & 0xFF;
        long labels = lsbLabels | hsbLabels << 32;
        byte extra = cursor.getByte();
        boolean dense = (extra & 1) > 0;
        record.setDense(dense);
        record.setNextRel(NodeStore.longFromIntAndMod(nextRel, relModifier));
        record.setNextProp(NodeStore.longFromIntAndMod(nextProp, propModifier));
        record.setInUse(inUse);
        record.setLabelField(labels, Collections.emptyList());
    }

    public void scanAllRecords(Visitor<NodeRecord, IOException> visitor) throws IOException {
        long startPageId;
        long endPageId = this.pageIdForRecord(this.getHighestPossibleIdInUse());
        long currentRecordId = 0L;
        NodeRecord record = new NodeRecord(-1L);
        int recordsPerPage = this.storeFile.pageSize() / this.getRecordSize();
        try (PageCursor cursor = this.storeFile.io(startPageId, 9);){
            for (long currentPageId = startPageId = this.pageIdForRecord(0L); currentPageId <= endPageId && cursor.next(); ++currentPageId) {
                for (int i = 0; i < recordsPerPage; ++i) {
                    record.setId(currentRecordId);
                    int offset = this.offsetForId(currentRecordId);
                    do {
                        cursor.setOffset(offset);
                        byte inUseByte = cursor.getByte();
                        boolean isInUse = this.isInUse(inUseByte);
                        this.readIntoRecord(cursor, record, inUseByte, isInUse);
                    } while (cursor.shouldRetry());
                    if (record.inUse() && visitor.visit(record)) {
                        return;
                    }
                    ++currentRecordId;
                }
            }
        }
    }

    public DynamicArrayStore getDynamicLabelStore() {
        return this.dynamicLabelStore;
    }

    public Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, Iterator<DynamicRecord> useFirst) {
        return NodeStore.allocateRecordsForDynamicLabels(nodeId, labels, useFirst, this.dynamicLabelStore);
    }

    public static Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, Iterator<DynamicRecord> useFirst, DynamicRecordAllocator allocator) {
        long[] storedLongs = LabelIdArray.prependNodeId(nodeId, labels);
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicArrayStore.allocateRecords(records, storedLongs, useFirst, allocator);
        return records;
    }

    public long[] getDynamicLabelsArray(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(this.dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public static long[] getDynamicLabelsArrayFromHeavyRecords(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, PropertyType.ARRAY));
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public Pair<Long, long[]> getDynamicLabelsArrayAndOwner(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(this.dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return Pair.of(storedLongs[0], LabelIdArray.stripNodeId(storedLongs));
    }

    public void updateDynamicLabelRecords(Iterable<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            this.dynamicLabelStore.updateRecord(record);
        }
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

