/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.ReadOnlyCountsTracker;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public class NeoStores
implements AutoCloseable {
    private static final StoreType[] STORE_TYPES = StoreType.values();
    private final Predicate<StoreType> INSTANTIATED_RECORD_STORES = new Predicate<StoreType>(){

        public boolean test(StoreType type) {
            return type.recordStore && NeoStores.this.stores[type.ordinal()] != null;
        }
    };
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final boolean createIfNotExist;
    private final File storeDir;
    private final File neoStoreFileName;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Object[] stores;
    private final Function<StoreType, Object> storeGetter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isStorePresent(PageCache pageCache, File storeDir) {
        File metaDataStore = new File(storeDir, "neostore");
        try (PagedFile ignore = pageCache.map(metaDataStore, MetaDataStore.getPageSize(pageCache), new OpenOption[0]);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    NeoStores(File neoStoreFileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, FileSystemAbstraction fileSystemAbstraction, boolean createIfNotExist, boolean eagerlyInitializedStores) {
        this.neoStoreFileName = neoStoreFileName;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.logProvider = logProvider;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.createIfNotExist = createIfNotExist;
        this.storeDir = neoStoreFileName.getParentFile();
        final Object[] stores = new Object[STORE_TYPES.length];
        if (eagerlyInitializedStores) {
            this.storeGetter = new Function<StoreType, Object>(){

                public Object apply(StoreType type) {
                    return stores[type.ordinal()];
                }
            };
            for (StoreType type : STORE_TYPES) {
                this.getInitializedStore(type, stores);
            }
        } else {
            this.storeGetter = new Function<StoreType, Object>(){

                public Object apply(StoreType type) {
                    return NeoStores.this.getInitializedStore(type, stores);
                }
            };
        }
        this.stores = stores;
    }

    public StoreStatement acquireStatement() {
        return new StoreStatement(this);
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    private File getStoreFileName(String substoreName) {
        return new File(this.neoStoreFileName.getPath() + substoreName);
    }

    @Override
    public void close() {
        for (StoreType type : STORE_TYPES) {
            this.closeStore(type);
        }
    }

    private void closeStore(StoreType type) {
        int i = type.ordinal();
        if (this.stores[i] != null) {
            type.close(this, this.stores[i]);
            this.stores[i] = null;
        }
    }

    public void flush() {
        try {
            CountsTracker counts = (CountsTracker)this.stores[StoreType.COUNTS.ordinal()];
            if (counts != null) {
                counts.rotate(this.getMetaDataStore().getLastCommittedTransactionId());
            }
            this.pageCache.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    private synchronized Object getInitializedStore(StoreType type, Object[] stores) {
        int i = type.ordinal();
        if (stores[i] == null) {
            stores[i] = type.open(this);
        }
        return stores[i];
    }

    <T extends CommonAbstractStore> T initialize(T store) {
        store.initialise(this.createIfNotExist);
        return store;
    }

    public MetaDataStore getMetaDataStore() {
        return (MetaDataStore)this.storeGetter.apply((Object)StoreType.META_DATA);
    }

    public NodeStore getNodeStore() {
        return (NodeStore)this.storeGetter.apply((Object)StoreType.NODE);
    }

    private DynamicArrayStore getNodeLabelStore() {
        return (DynamicArrayStore)this.storeGetter.apply((Object)StoreType.NODE_LABEL);
    }

    public RelationshipStore getRelationshipStore() {
        return (RelationshipStore)this.storeGetter.apply((Object)StoreType.RELATIONSHIP);
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return (RelationshipTypeTokenStore)this.storeGetter.apply((Object)StoreType.RELATIONSHIP_TYPE_TOKEN);
    }

    private DynamicStringStore getRelationshipTypeTokenNamesStore() {
        return (DynamicStringStore)this.storeGetter.apply((Object)StoreType.RELATIONSHIP_TYPE_TOKEN_NAME);
    }

    public LabelTokenStore getLabelTokenStore() {
        return (LabelTokenStore)this.storeGetter.apply((Object)StoreType.LABEL_TOKEN);
    }

    private DynamicStringStore getLabelTokenNamesStore() {
        return (DynamicStringStore)this.storeGetter.apply((Object)StoreType.LABEL_TOKEN_NAME);
    }

    public PropertyStore getPropertyStore() {
        return (PropertyStore)this.storeGetter.apply((Object)StoreType.PROPERTY);
    }

    private DynamicStringStore getStringPropertyStore() {
        return (DynamicStringStore)this.storeGetter.apply((Object)StoreType.PROPERTY_STRING);
    }

    private DynamicArrayStore getArrayPropertyStore() {
        return (DynamicArrayStore)this.storeGetter.apply((Object)StoreType.PROPERTY_ARRAY);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return (PropertyKeyTokenStore)this.storeGetter.apply((Object)StoreType.PROPERTY_KEY_TOKEN);
    }

    private DynamicStringStore getPropertyKeyTokenNamesStore() {
        return (DynamicStringStore)this.storeGetter.apply((Object)StoreType.PROPERTY_KEY_TOKEN_NAME);
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return (RelationshipGroupStore)this.storeGetter.apply((Object)StoreType.RELATIONSHIP_GROUP);
    }

    public SchemaStore getSchemaStore() {
        return (SchemaStore)this.storeGetter.apply((Object)StoreType.SCHEMA);
    }

    public CountsTracker getCounts() {
        return (CountsTracker)this.storeGetter.apply((Object)StoreType.COUNTS);
    }

    private CountsTracker createWritableCountsTracker(File fileName) {
        return new CountsTracker(this.logProvider, this.fileSystemAbstraction, this.pageCache, this.config, fileName);
    }

    private ReadOnlyCountsTracker createReadOnlyCountsTracker(File fileName) {
        return new ReadOnlyCountsTracker(this.logProvider, this.fileSystemAbstraction, this.pageCache, this.config, fileName);
    }

    private Iterable<CommonAbstractStore> instantiatedRecordStores() {
        FilteringIterator<StoreType> storeTypes = new FilteringIterator<StoreType>(IteratorUtil.iterator(STORE_TYPES), this.INSTANTIATED_RECORD_STORES);
        return IteratorUtil.loop(new IteratorWrapper<CommonAbstractStore, StoreType>(storeTypes){

            @Override
            protected CommonAbstractStore underlyingObjectToObject(StoreType type) {
                return (CommonAbstractStore)NeoStores.this.stores[type.ordinal()];
            }
        });
    }

    public void makeStoreOk() {
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.makeStoreOk();
        }
    }

    public void verifyStoreOk() {
        this.visitStore(new Visitor<CommonAbstractStore, RuntimeException>(){

            @Override
            public boolean visit(CommonAbstractStore element) {
                element.checkStoreOk();
                return false;
            }
        });
    }

    public void logVersions(Logger msgLog) {
        msgLog.log("Store versions:");
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.logVersions(msgLog);
        }
    }

    public void logIdUsage(Logger msgLog) {
        msgLog.log("Id usage:");
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.logIdUsage(msgLog);
        }
    }

    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        for (CommonAbstractStore store : this.instantiatedRecordStores()) {
            store.visitStore(visitor);
        }
    }

    public void rebuildCountStoreIfNeeded() throws IOException {
        this.getCounts().start();
    }

    public void deleteIdGenerators() {
        this.visitStore(new Visitor<CommonAbstractStore, RuntimeException>(){

            @Override
            public boolean visit(CommonAbstractStore store) throws RuntimeException {
                store.deleteIdGenerator();
                return false;
            }
        });
    }

    public void assertOpen() {
        if (this.stores[StoreType.NODE.ordinal()] == null) {
            throw new IllegalStateException("Database has been shutdown");
        }
    }

    private static enum StoreType {
        NODE_LABEL{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".nodestore.db.labels");
                int blockSizeFromConfiguration = me.config.get(GraphDatabaseSettings.label_block_size);
                return me.initialize(new DynamicArrayStore(fileName, me.config, IdType.NODE_LABELS, me.idGeneratorFactory, me.pageCache, me.logProvider, blockSizeFromConfiguration));
            }
        }
        ,
        NODE{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".nodestore.db");
                return me.initialize(new NodeStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider, me.getNodeLabelStore()));
            }
        }
        ,
        PROPERTY_KEY_TOKEN_NAME{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".propertystore.db.index.keys");
                return me.initialize(new DynamicStringStore(fileName, me.config, IdType.PROPERTY_KEY_TOKEN_NAME, me.idGeneratorFactory, me.pageCache, me.logProvider, 30));
            }
        }
        ,
        PROPERTY_KEY_TOKEN{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".propertystore.db.index");
                return me.initialize(new PropertyKeyTokenStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider, me.getPropertyKeyTokenNamesStore()));
            }
        }
        ,
        PROPERTY_STRING{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".propertystore.db.strings");
                int blockSizeFromConfiguration = me.config.get(GraphDatabaseSettings.string_block_size);
                return me.initialize(new DynamicStringStore(fileName, me.config, IdType.STRING_BLOCK, me.idGeneratorFactory, me.pageCache, me.logProvider, blockSizeFromConfiguration));
            }
        }
        ,
        PROPERTY_ARRAY{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".propertystore.db.arrays");
                int blockSizeFromConfiguration = me.config.get(GraphDatabaseSettings.array_block_size);
                return me.initialize(new DynamicArrayStore(fileName, me.config, IdType.ARRAY_BLOCK, me.idGeneratorFactory, me.pageCache, me.logProvider, blockSizeFromConfiguration));
            }
        }
        ,
        PROPERTY{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".propertystore.db");
                return me.initialize(new PropertyStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider, me.getStringPropertyStore(), me.getPropertyKeyTokenStore(), me.getArrayPropertyStore()));
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".relationshipstore.db");
                return me.initialize(new RelationshipStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider));
            }
        }
        ,
        RELATIONSHIP_TYPE_TOKEN_NAME{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".relationshiptypestore.db.names");
                return me.initialize(new DynamicStringStore(fileName, me.config, IdType.RELATIONSHIP_TYPE_TOKEN_NAME, me.idGeneratorFactory, me.pageCache, me.logProvider, 30));
            }
        }
        ,
        RELATIONSHIP_TYPE_TOKEN{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".relationshiptypestore.db");
                return me.initialize(new RelationshipTypeTokenStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider, me.getRelationshipTypeTokenNamesStore()));
            }
        }
        ,
        LABEL_TOKEN_NAME{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".labeltokenstore.db.names");
                return me.initialize(new DynamicStringStore(fileName, me.config, IdType.LABEL_TOKEN_NAME, me.idGeneratorFactory, me.pageCache, me.logProvider, 30));
            }
        }
        ,
        LABEL_TOKEN{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".labeltokenstore.db");
                return me.initialize(new LabelTokenStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider, me.getLabelTokenNamesStore()));
            }
        }
        ,
        SCHEMA{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".schemastore.db");
                return me.initialize(new SchemaStore(fileName, me.config, IdType.SCHEMA, me.idGeneratorFactory, me.pageCache, me.logProvider));
            }
        }
        ,
        RELATIONSHIP_GROUP{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                File fileName = me.getStoreFileName(".relationshipgroupstore.db");
                return me.initialize(new RelationshipGroupStore(fileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider));
            }
        }
        ,
        COUNTS(false){

            @Override
            public CountsTracker open(final NeoStores me) {
                File fileName = me.getStoreFileName(".counts.db");
                boolean readOnly = me.config.get(GraphDatabaseSettings.read_only);
                CountsTracker counts = readOnly ? me.createReadOnlyCountsTracker(fileName) : me.createWritableCountsTracker(fileName);
                counts.setInitializer(new DataInitializer<CountsAccessor.Updater>(){
                    private final Log log;
                    {
                        this.log = me.logProvider.getLog(MetaDataStore.class);
                    }

                    @Override
                    public void initialize(CountsAccessor.Updater updater) {
                        this.log.warn("Missing counts store, rebuilding it.");
                        new CountsComputer(me).initialize(updater);
                    }

                    @Override
                    public long initialVersion() {
                        return me.getMetaDataStore().getLastCommittedTransactionId();
                    }
                });
                try {
                    counts.init();
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Failed to initialize counts store", e);
                }
                return counts;
            }

            @Override
            void close(NeoStores me, Object object) {
                CountsTracker counts = (CountsTracker)object;
                try {
                    counts.rotate(me.getMetaDataStore().getLastCommittedTransactionId());
                    counts.shutdown();
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException(e);
                }
                finally {
                    counts = null;
                }
            }
        }
        ,
        META_DATA{

            @Override
            public CommonAbstractStore open(NeoStores me) {
                return me.initialize(new MetaDataStore(me.neoStoreFileName, me.config, me.idGeneratorFactory, me.pageCache, me.logProvider));
            }
        };

        private final boolean recordStore;

        private StoreType() {
            this(true);
        }

        private StoreType(boolean recordStore) {
            this.recordStore = recordStore;
        }

        abstract Object open(NeoStores var1);

        void close(NeoStores me, Object object) {
            ((CommonAbstractStore)object).close();
        }
    }
}

