/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractStore;
import org.neo4j.kernel.impl.store.HighestTransactionId;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public class MetaDataStore
extends AbstractStore
implements TransactionIdStore,
LogVersionRepository {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final long FIELD_NOT_PRESENT = -1L;
    public static final long FIELD_NOT_INITIALIZED = Long.MIN_VALUE;
    public static final int RECORD_SIZE = 9;
    public static final String DEFAULT_NAME = "neostore";
    public static final int META_DATA_RECORD_COUNT = Position.values().length;
    private volatile long creationTimeField = Long.MIN_VALUE;
    private volatile long randomNumberField = Long.MIN_VALUE;
    private volatile long versionField = Long.MIN_VALUE;
    private final AtomicLong lastCommittingTxField = new AtomicLong(Long.MIN_VALUE);
    private volatile long storeVersionField = Long.MIN_VALUE;
    private volatile long graphNextPropField = Long.MIN_VALUE;
    private volatile long latestConstraintIntroducingTxField = Long.MIN_VALUE;
    private volatile long upgradeTxIdField = Long.MIN_VALUE;
    private volatile long upgradeTimeField = Long.MIN_VALUE;
    private volatile long lastClosedTransactionLogVersion = Long.MIN_VALUE;
    private volatile long lastClosedTransactionLogByteOffset = Long.MIN_VALUE;
    private volatile long upgradeTxChecksumField = Long.MIN_VALUE;
    private final HighestTransactionId highestCommittedTransaction = new HighestTransactionId(Long.MIN_VALUE, Long.MIN_VALUE);
    private final OutOfOrderSequence lastClosedTx = new ArrayQueueOutOfOrderSequence(-1L, 200, new long[2]);
    private final CappedOperation<Void> transactionCloseWaitLogger = new CappedOperation<Void>(new CappedOperation.Switch[]{CappedOperation.time(30L, TimeUnit.SECONDS)}){

        @Override
        protected void triggered(Void event) {
            MetaDataStore.this.log.info(String.format("Waiting for all transactions to close...%n committed:  %s%n  committing: %s%n  closed:     %s", MetaDataStore.this.highestCommittedTransaction.get(), MetaDataStore.this.lastCommittingTxField, MetaDataStore.this.lastClosedTx));
        }
    };

    MetaDataStore(File fileName, Config conf, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider) {
        super(fileName, conf, IdType.NEOSTORE_BLOCK, idGeneratorFactory, pageCache, logProvider);
    }

    @Override
    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        super.initialiseNewStoreFile(file);
        StoreId storeId = new StoreId();
        this.storeFile = file;
        this.setCreationTime(storeId.getCreationTime());
        this.setRandomNumber(storeId.getRandomId());
        this.setUpgradeTime(storeId.getCreationTime());
        this.setUpgradeTransaction(1L, 0L);
        this.setCurrentLogVersion(0L);
        this.setLastCommittedAndClosedTransactionId(1L, 0L, 0L, 16L);
        this.setStoreVersion(MetaDataStore.versionStringToLong("v0.A.6"));
        this.setGraphNextProp(-1L);
        this.setLatestConstraintIntroducingTx(0L);
        this.flush();
        this.storeFile = null;
    }

    @Override
    protected void initialiseNewIdGenerator(IdGenerator idGenerator) {
        super.initialiseNewIdGenerator(idGenerator);
        for (int i = 0; i < META_DATA_RECORD_COUNT; ++i) {
            this.nextId();
        }
    }

    public void checkVersion() {
        long record;
        try {
            record = MetaDataStore.getRecord(this.pageCache, this.storageFileName, Position.STORE_VERSION);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        if (record == -1L) {
            return;
        }
        String foundVersion = MetaDataStore.versionLongToString(record);
        if (!"v0.A.6".equals(foundVersion)) {
            throw new IllegalStateException(String.format("Mismatching store version found (%s while expecting %s). The store cannot be automatically upgraded since it isn't cleanly shutdown. Recover by starting the database using the previous Neo4j version, followed by a clean shutdown. Then start with this version again.", foundVersion, "v0.A.6"));
        }
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static long setRecord(PageCache pageCache, File neoStore, Position position, long value) throws IOException {
        long previousValue = Long.MIN_VALUE;
        try (PagedFile pagedFile = pageCache.map(neoStore, MetaDataStore.getPageSize(pageCache), new OpenOption[0]);){
            int recordOffset = 9 * position.id;
            try (PageCursor pageCursor = pagedFile.io(0L, 2);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset(recordOffset);
                        byte inUse = pageCursor.getByte();
                        long record = pageCursor.getLong();
                        if (inUse == Record.IN_USE.byteValue()) {
                            previousValue = record;
                        }
                        pageCursor.setOffset(recordOffset);
                        pageCursor.putByte(Record.IN_USE.byteValue());
                        pageCursor.putLong(value);
                    } while (pageCursor.shouldRetry());
                }
            }
        }
        return previousValue;
    }

    public static long getRecord(PageCache pageCache, File neoStore, Position recordPosition) throws IOException {
        block32: {
            try (PagedFile pagedFile = pageCache.map(neoStore, MetaDataStore.getPageSize(pageCache), new OpenOption[0]);){
                if (pagedFile.getLastPageId() == -1L) break block32;
                try (PageCursor cursor = pagedFile.io(0L, 1);){
                    if (cursor.next()) {
                        long record;
                        byte recordByte;
                        do {
                            cursor.setOffset(9 * recordPosition.id);
                            recordByte = cursor.getByte();
                            record = cursor.getLong();
                        } while (cursor.shouldRetry());
                        if (recordByte == Record.IN_USE.byteValue()) {
                            long l = record;
                            return l;
                        }
                    }
                }
            }
        }
        return -1L;
    }

    static int getPageSize(PageCache pageCache) {
        return pageCache.pageSize() - pageCache.pageSize() % 9;
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getUpgradeTime(), this.upgradeTxIdField);
    }

    public long getUpgradeTime() {
        this.checkInitialized(this.upgradeTimeField);
        return this.upgradeTimeField;
    }

    public void setUpgradeTime(long time) {
        this.setRecord(Position.UPGRADE_TIME, time);
        this.upgradeTimeField = time;
    }

    public void setUpgradeTransaction(long id, long checksum) {
        this.setRecord(Position.UPGRADE_TRANSACTION_ID, id);
        this.upgradeTxIdField = id;
        this.setRecord(Position.UPGRADE_TRANSACTION_CHECKSUM, checksum);
        this.upgradeTxChecksumField = checksum;
    }

    public long getCreationTime() {
        this.checkInitialized(this.creationTimeField);
        return this.creationTimeField;
    }

    public void setCreationTime(long time) {
        this.setRecord(Position.TIME, time);
        this.creationTimeField = time;
    }

    public long getRandomNumber() {
        this.checkInitialized(this.randomNumberField);
        return this.randomNumberField;
    }

    public void setRandomNumber(long nr) {
        this.setRecord(Position.RANDOM_NUMBER, nr);
        this.randomNumberField = nr;
    }

    @Override
    public long getCurrentLogVersion() {
        this.checkInitialized(this.versionField);
        return this.versionField;
    }

    public void setCurrentLogVersion(long version) {
        this.setRecord(Position.LOG_VERSION, version);
        this.versionField = version;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long incrementAndGetVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getStoreVersion() {
        this.checkInitialized(this.storeVersionField);
        return this.storeVersionField;
    }

    public void setStoreVersion(long version) {
        this.setRecord(Position.STORE_VERSION, version);
        this.storeVersionField = version;
    }

    public long getGraphNextProp() {
        this.checkInitialized(this.graphNextPropField);
        return this.graphNextPropField;
    }

    public void setGraphNextProp(long propId) {
        this.setRecord(Position.FIRST_GRAPH_PROPERTY, propId);
        this.graphNextPropField = propId;
    }

    public long getLatestConstraintIntroducingTx() {
        this.checkInitialized(this.latestConstraintIntroducingTxField);
        return this.latestConstraintIntroducingTxField;
    }

    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx) {
        this.setRecord(Position.LAST_CONSTRAINT_TRANSACTION, latestConstraintIntroducingTx);
        this.latestConstraintIntroducingTxField = latestConstraintIntroducingTx;
    }

    private void readAllFields(PageCursor cursor) throws IOException {
        do {
            this.creationTimeField = this.getRecordValue(cursor, Position.TIME);
            this.randomNumberField = this.getRecordValue(cursor, Position.RANDOM_NUMBER);
            this.versionField = this.getRecordValue(cursor, Position.LOG_VERSION);
            this.upgradeTxIdField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_ID);
            this.upgradeTimeField = this.getRecordValue(cursor, Position.UPGRADE_TIME);
            long lastCommittedTxId = this.getRecordValue(cursor, Position.LAST_TRANSACTION_ID);
            this.lastCommittingTxField.set(lastCommittedTxId);
            this.storeVersionField = this.getRecordValue(cursor, Position.STORE_VERSION);
            this.graphNextPropField = this.getRecordValue(cursor, Position.FIRST_GRAPH_PROPERTY);
            this.latestConstraintIntroducingTxField = this.getRecordValue(cursor, Position.LAST_CONSTRAINT_TRANSACTION);
            this.lastClosedTransactionLogVersion = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            this.lastClosedTransactionLogByteOffset = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
            this.lastClosedTx.set(lastCommittedTxId, new long[]{this.lastClosedTransactionLogVersion, this.lastClosedTransactionLogByteOffset});
            this.highestCommittedTransaction.set(lastCommittedTxId, this.getRecordValue(cursor, Position.LAST_TRANSACTION_CHECKSUM));
            this.upgradeTxChecksumField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM);
        } while (cursor.shouldRetry());
    }

    private long getRecordValue(PageCursor cursor, Position position) {
        int offset = position.id * this.getRecordSize();
        cursor.setOffset(offset);
        if (cursor.getByte() == Record.IN_USE.byteValue()) {
            return cursor.getLong();
        }
        return -1L;
    }

    private void incrementVersion(PageCursor cursor) throws IOException {
        long value;
        int offset = Position.LOG_VERSION.id * this.getRecordSize();
        do {
            cursor.setOffset(offset + 1);
            value = cursor.getLong() + 1L;
            cursor.setOffset(offset + 1);
            cursor.putLong(value);
        } while (cursor.shouldRetry());
        this.versionField = value;
    }

    private void refreshFields() {
        this.scanAllFields(1, new Visitor<PageCursor, IOException>(){

            @Override
            public boolean visit(PageCursor element) throws IOException {
                MetaDataStore.this.readAllFields(element);
                return false;
            }
        });
    }

    private void scanAllFields(int pf_flags, Visitor<PageCursor, IOException> visitor) {
        try (PageCursor cursor = this.storeFile.io(0L, pf_flags);){
            if (cursor.next()) {
                visitor.visit(cursor);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void setRecord(Position recordPosition, long value) {
        long id = recordPosition.id;
        long pageId = this.pageIdForRecord(id);
        this.setHighestPossibleIdInUse(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                int offset = this.offsetForId(id);
                do {
                    cursor.setOffset(offset);
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public NeoStoreRecord asRecord() {
        NeoStoreRecord result = new NeoStoreRecord();
        result.setNextProp(this.getGraphNextProp());
        return result;
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Unknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits(8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put(c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs(new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    @Override
    public long nextCommittingTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittingTxField.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionCommitted(long transactionId, long checksum) {
        if (this.highestCommittedTransaction.offer(transactionId, checksum)) {
            MetaDataStore metaDataStore = this;
            synchronized (metaDataStore) {
                if (this.highestCommittedTransaction.get().transactionId() == transactionId) {
                    this.setRecord(Position.LAST_TRANSACTION_ID, transactionId);
                    this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum);
                }
            }
        }
    }

    @Override
    public long getLastCommittedTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get().transactionId();
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get();
    }

    @Override
    public TransactionId getUpgradeTransaction() {
        this.checkInitialized(this.upgradeTxChecksumField);
        return new TransactionId(this.upgradeTxIdField, this.upgradeTxChecksumField);
    }

    @Override
    public long getLastClosedTransactionId() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    @Override
    public long[] getLastClosedTransaction() {
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.get();
    }

    private void checkInitialized(long field) {
        if (field == Long.MIN_VALUE) {
            this.refreshFields();
        }
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long logVersion, long byteOffset) {
        this.setRecord(Position.LAST_TRANSACTION_ID, transactionId);
        this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset);
        this.checkInitialized(this.lastCommittingTxField.get());
        this.lastCommittingTxField.set(transactionId);
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
        this.lastClosedTransactionLogVersion = logVersion;
        this.lastClosedTransactionLogByteOffset = byteOffset;
        this.highestCommittedTransaction.set(transactionId, checksum);
    }

    @Override
    public void transactionClosed(long transactionId, long logVersion, long byteOffset) {
        if (this.lastClosedTx.offer(transactionId, new long[]{logVersion, byteOffset})) {
            long[] lastClosedTransactionData = this.lastClosedTx.get();
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTransactionData[1]);
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTransactionData[2]);
            this.lastClosedTransactionLogVersion = lastClosedTransactionData[1];
            this.lastClosedTransactionLogByteOffset = lastClosedTransactionData[2];
        }
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        boolean onPar;
        boolean bl = onPar = this.lastClosedTx.getHighestGapFreeNumber() == this.lastCommittingTxField.get();
        if (!onPar) {
            this.transactionCloseWaitLogger.event(null);
        }
        return onPar;
    }

    public void logRecords(final Logger msgLog) {
        this.scanAllFields(1, new Visitor<PageCursor, IOException>(){

            @Override
            public boolean visit(PageCursor element) throws IOException {
                for (Position position : Position.values()) {
                    long value = MetaDataStore.this.getRecordValue(element, position);
                    msgLog.log(position.name() + " (" + position.description() + "): " + value);
                }
                return false;
            }
        });
    }

    public static enum Position {
        TIME(0, "Creation time"),
        RANDOM_NUMBER(1, "Random number for store id"),
        LOG_VERSION(2, "Current log version"),
        LAST_TRANSACTION_ID(3, "Last committed transaction"),
        STORE_VERSION(4, "Store format version"),
        FIRST_GRAPH_PROPERTY(5, "First property record containing graph properties"),
        LAST_CONSTRAINT_TRANSACTION(6, "Last committed transaction containing constraint changes"),
        UPGRADE_TRANSACTION_ID(7, "Transaction id most recent upgrade was performed at"),
        UPGRADE_TIME(8, "Time of last upgrade"),
        LAST_TRANSACTION_CHECKSUM(9, "Checksum of last committed transaction"),
        UPGRADE_TRANSACTION_CHECKSUM(10, "Checksum of transaction id the most recent upgrade was performed at"),
        LAST_CLOSED_TRANSACTION_LOG_VERSION(11, "Log version where the last transaction commit entry has been written into"),
        LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET(12, "Byte offset in the log file where the last transaction commit entry has been written into");

        private final int id;
        private final String description;

        private Position(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

