/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurablePageSwapperFactory;
import org.neo4j.logging.Log;

public class ConfiguringPageCacheFactory {
    private final PageSwapperFactory swapperFactory;
    private final Config config;
    private final PageCacheTracer tracer;
    private final Log log;
    private PageCache pageCache;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer tracer, Log log) {
        this.swapperFactory = this.createAndConfigureSwapperFactory(fs, config);
        this.config = config;
        this.tracer = tracer;
        this.log = log;
    }

    private PageSwapperFactory createAndConfigureSwapperFactory(FileSystemAbstraction fs, Config config) {
        String desiredImplementation = config.get(GraphDatabaseSettings.pagecache_swapper);
        if (desiredImplementation != null) {
            for (PageSwapperFactory factory : Service.load(PageSwapperFactory.class)) {
                if (!factory.implementationName().equals(desiredImplementation)) continue;
                factory.setFileSystemAbstraction(fs);
                if (factory instanceof ConfigurablePageSwapperFactory) {
                    ConfigurablePageSwapperFactory configurableFactory = (ConfigurablePageSwapperFactory)factory;
                    configurableFactory.configure(config);
                }
                return factory;
            }
        }
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.setFileSystemAbstraction(fs);
        return factory;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        int maxPages = this.calculateMaxPages(this.config, cachePageSize);
        return new MuninnPageCache(this.swapperFactory, maxPages, cachePageSize, this.tracer);
    }

    public int calculateMaxPages(Config config, int cachePageSize) {
        long maxHeap;
        long pageCacheMemory = config.get(GraphDatabaseSettings.pagecache_memory);
        if (pageCacheMemory / (maxHeap = Runtime.getRuntime().maxMemory()) > 100L) {
            this.log.warn("The memory configuration looks unbalanced. It is generally recommended to have at least 10 KiB of heap memory, for every 1 MiB of page cache memory. The current configuration is allocating %s bytes for the page cache, and %s bytes for the heap.", new Object[]{pageCacheMemory, maxHeap});
        }
        long pageCount = pageCacheMemory / (long)cachePageSize;
        return (int)Math.min(2147481647L, pageCount);
    }

    public int calculatePageSize(Config config, PageSwapperFactory swapperFactory) {
        int pageSwappersPageSizeHint = swapperFactory.getCachePageSizeHint();
        int configuredPageSize = config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue();
        if (configuredPageSize == 0 || swapperFactory.isCachePageSizeHintStrict()) {
            return pageSwappersPageSizeHint;
        }
        return configuredPageSize;
    }

    public void dumpConfiguration() {
        int cachePageSize = this.calculatePageSize(this.config, this.swapperFactory);
        long maxPages = this.calculateMaxPages(this.config, cachePageSize);
        long totalPhysicalMemory = this.totalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + ByteUnit.Byte.toMebiBytes(totalPhysicalMemory);
        long maxVmUsageMb = ByteUnit.Byte.toMebiBytes(Runtime.getRuntime().maxMemory());
        long pageCacheMb = ByteUnit.Byte.toMebiBytes(maxPages * (long)cachePageSize);
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB," + " Heap size: " + maxVmUsageMb + " MiB," + " Page cache size: " + pageCacheMb + " MiB.";
        this.log.info(msg);
    }

    public long totalPhysicalMemory() {
        try {
            Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            return (Long)method.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
        }
        catch (Exception | LinkageError e) {
            return -1L;
        }
    }
}

