/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeConstraintDefinition;

public class UniquenessConstraintDefinition
extends NodeConstraintDefinition {
    public UniquenessConstraintDefinition(InternalSchemaActions actions, Label label, String propertyKey) {
        super(actions, label, propertyKey);
    }

    @Override
    public void drop() {
        this.assertInUnterminatedTransaction();
        this.actions.dropPropertyUniquenessConstraint(this.label, this.propertyKey);
    }

    @Override
    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.UNIQUENESS;
    }

    @Override
    public String toString() {
        return String.format("ON (%1$s:%2$s) ASSERT %1$s.%3$s IS UNIQUE", this.label.name().toLowerCase(), this.label.name(), this.propertyKey);
    }
}

