/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.IntValue;
import org.neo4j.function.IntSupplier;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.cursor.DegreeItem;
import org.neo4j.kernel.api.cursor.LabelItem;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.impl.api.store.StoreLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public abstract class StoreAbstractNodeCursor
extends NodeItem.NodeItemHelper
implements Cursor<NodeItem>,
NodeItem {
    protected final NodeRecord nodeRecord;
    protected NodeStore nodeStore;
    protected RelationshipGroupStore relationshipGroupStore;
    protected RelationshipStore relationshipStore;
    protected StoreStatement storeStatement;
    private InstanceCache<StoreLabelCursor> labelCursor;
    private InstanceCache<StoreSingleLabelCursor> singleLabelCursor;
    private InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipCursor;
    private InstanceCache<StoreSinglePropertyCursor> singlePropertyCursor;
    private InstanceCache<StorePropertyCursor> allPropertyCursor;

    public StoreAbstractNodeCursor(NodeRecord nodeRecord, final NeoStores neoStores, final StoreStatement storeStatement) {
        this.nodeRecord = nodeRecord;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.storeStatement = storeStatement;
        this.labelCursor = new InstanceCache<StoreLabelCursor>(){

            @Override
            protected StoreLabelCursor create() {
                return new StoreLabelCursor(this);
            }
        };
        this.singleLabelCursor = new InstanceCache<StoreSingleLabelCursor>(){

            @Override
            protected StoreSingleLabelCursor create() {
                return new StoreSingleLabelCursor(this);
            }
        };
        this.nodeRelationshipCursor = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor(new RelationshipRecord(-1L), neoStores, new RelationshipGroupRecord(-1L, -1), storeStatement, this);
            }
        };
        this.singlePropertyCursor = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(neoStores.getPropertyStore(), this);
            }
        };
        this.allPropertyCursor = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(neoStores.getPropertyStore(), this);
            }
        };
    }

    public NodeItem get() {
        return this;
    }

    @Override
    public long id() {
        return this.nodeRecord.getId();
    }

    @Override
    public Cursor<LabelItem> labels() {
        return this.labelCursor.get().init(NodeLabelsField.parseLabelsField(this.nodeRecord).get(this.nodeStore));
    }

    @Override
    public Cursor<LabelItem> label(int labelId) {
        return this.singleLabelCursor.get().init(NodeLabelsField.parseLabelsField(this.nodeRecord).get(this.nodeStore), labelId);
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.allPropertyCursor.get().init(this.nodeRecord.getNextProp());
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.singlePropertyCursor.get().init(this.nodeRecord.getNextProp(), propertyKeyId);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        return this.nodeRelationshipCursor.get().init(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction, null);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        return this.nodeRelationshipCursor.get().init(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction, relTypes);
    }

    @Override
    public Cursor<IntSupplier> relationshipTypes() {
        if (this.nodeRecord.isDense()) {
            return new Cursor<IntSupplier>(){
                private long groupId;
                private final IntValue value;
                {
                    this.groupId = StoreAbstractNodeCursor.this.nodeRecord.getNextRel();
                    this.value = new IntValue();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean next() {
                    if (this.groupId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        return false;
                    }
                    RelationshipGroupRecord group = StoreAbstractNodeCursor.this.relationshipGroupStore.getRecord(this.groupId);
                    try {
                        this.value.setValue(group.getType());
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.groupId = group.getNext();
                    }
                }

                public void close() {
                }

                public IntSupplier get() {
                    return this.value;
                }
            };
        }
        final Cursor<RelationshipItem> relationships = this.relationships(Direction.BOTH);
        return new Cursor<IntSupplier>(){
            private final PrimitiveIntSet foundTypes = Primitive.intSet((int)5);
            private final IntValue value = new IntValue();

            public boolean next() {
                while (relationships.next()) {
                    if (this.foundTypes.contains(((RelationshipItem)relationships.get()).type())) continue;
                    this.foundTypes.add(((RelationshipItem)relationships.get()).type());
                    this.value.setValue(((RelationshipItem)relationships.get()).type());
                    return true;
                }
                return false;
            }

            public void close() {
            }

            public IntSupplier get() {
                return this.value;
            }
        };
    }

    @Override
    public int degree(Direction direction) {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            long count = 0L;
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(groupId);
                count += this.nodeDegreeByDirection(group, direction);
                groupId = group.getNext();
            }
            return (int)count;
        }
        try (Cursor<RelationshipItem> relationship = this.relationships(direction);){
            int count = 0;
            while (relationship.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public int degree(Direction direction, int relType) {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = this.relationshipGroupStore.getRecord(groupId);
                if (group.getType() == relType) {
                    return (int)this.nodeDegreeByDirection(group, direction);
                }
                groupId = group.getNext();
            }
            return 0;
        }
        try (Cursor<RelationshipItem> relationship = this.relationships(direction, relType);){
            int count = 0;
            while (relationship.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public Cursor<DegreeItem> degrees() {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            return new DegreeItemDenseCursor(groupId);
        }
        PrimitiveIntObjectMap degrees = Primitive.intObjectMap((int)5);
        try (Cursor<RelationshipItem> relationship = this.relationships(Direction.BOTH);){
            while (relationship.next()) {
                RelationshipItem rel = (RelationshipItem)relationship.get();
                int[] byType = (int[])degrees.get(rel.type());
                if (byType == null) {
                    byType = new int[3];
                    degrees.put(rel.type(), (Object)byType);
                }
                int n = this.directionOf(this.nodeRecord.getId(), rel.id(), rel.startNode(), rel.endNode()).ordinal();
                byType[n] = byType[n] + 1;
            }
        }
        PrimitiveIntIterator keys = degrees.iterator();
        return new DegreeItemIterator(keys, (PrimitiveIntObjectMap<int[]>)degrees);
    }

    @Override
    public boolean isDense() {
        return this.nodeRecord.isDense();
    }

    private long nodeDegreeByDirection(RelationshipGroupRecord group, Direction direction) {
        long loopCount = this.countByFirstPrevPointer(group.getFirstLoop());
        switch (direction) {
            case OUTGOING: {
                return this.countByFirstPrevPointer(group.getFirstOut()) + loopCount;
            }
            case INCOMING: {
                return this.countByFirstPrevPointer(group.getFirstIn()) + loopCount;
            }
            case BOTH: {
                return this.countByFirstPrevPointer(group.getFirstOut()) + this.countByFirstPrevPointer(group.getFirstIn()) + loopCount;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    private long countByFirstPrevPointer(long relationshipId) {
        if (relationshipId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0L;
        }
        RelationshipRecord record = this.relationshipStore.getRecord(relationshipId);
        if (record.getFirstNode() == this.nodeRecord.getId()) {
            return record.getFirstPrevRel();
        }
        if (record.getSecondNode() == this.nodeRecord.getId()) {
            return record.getSecondPrevRel();
        }
        throw new InvalidRecordException("Node " + this.nodeRecord.getId() + " neither start nor end node of " + record);
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }

    private class DegreeItemDenseCursor
    implements Cursor<DegreeItem>,
    DegreeItem {
        private long groupId;
        private int type;
        private long outgoing;
        private long incoming;

        public DegreeItemDenseCursor(long groupId) {
            this.groupId = groupId;
        }

        public boolean next() {
            if (this.groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                RelationshipGroupRecord group = StoreAbstractNodeCursor.this.relationshipGroupStore.getRecord(this.groupId);
                this.type = group.getType();
                long loop = StoreAbstractNodeCursor.this.countByFirstPrevPointer(group.getFirstLoop());
                this.outgoing = StoreAbstractNodeCursor.this.countByFirstPrevPointer(group.getFirstOut()) + loop;
                this.incoming = StoreAbstractNodeCursor.this.countByFirstPrevPointer(group.getFirstIn()) + loop;
                this.groupId = group.getNext();
                return true;
            }
            return false;
        }

        public void close() {
        }

        public DegreeItem get() {
            return this;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }
    }

    private static class DegreeItemIterator
    implements Cursor<DegreeItem>,
    DegreeItem {
        private final PrimitiveIntObjectMap<int[]> degrees;
        private PrimitiveIntIterator keys;
        private int type;
        private int outgoing;
        private int incoming;

        public DegreeItemIterator(PrimitiveIntIterator keys, PrimitiveIntObjectMap<int[]> degrees) {
            this.keys = keys;
            this.degrees = degrees;
        }

        public void close() {
            this.keys = null;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }

        public DegreeItem get() {
            if (this.keys == null) {
                throw new IllegalStateException();
            }
            return this;
        }

        public boolean next() {
            if (this.keys != null && this.keys.hasNext()) {
                this.type = this.keys.next();
                int[] degreeValues = (int[])this.degrees.get(this.type);
                this.outgoing = degreeValues[0] + degreeValues[2];
                this.incoming = degreeValues[1] + degreeValues[2];
                return true;
            }
            this.keys = null;
            return false;
        }
    }
}

