/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;

public class CountCommittedTransactionThreshold
implements CheckPointThreshold {
    private final int notificationThreshold;
    private volatile long nextTransactionIdTarget;

    public CountCommittedTransactionThreshold(int notificationThreshold) {
        this.notificationThreshold = notificationThreshold;
    }

    @Override
    public void initialize(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    public boolean isCheckPointingNeeded(long lastCommittedTransactionId) {
        return lastCommittedTransactionId >= this.nextTransactionIdTarget;
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }
}

