/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private final TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final CheckPointThreshold threshold;
    private final StoreFlusher storeFlusher;
    private final LogPruning logPruning;
    private final KernelHealth kernelHealth;
    private final Log msgLog;
    private final CheckPointTracer tracer;

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, StoreFlusher storeFlusher, LogPruning logPruning, TransactionAppender appender, KernelHealth kernelHealth, LogProvider logProvider, CheckPointTracer tracer) {
        this.appender = appender;
        this.transactionIdStore = transactionIdStore;
        this.threshold = threshold;
        this.storeFlusher = storeFlusher;
        this.logPruning = logPruning;
        this.kernelHealth = kernelHealth;
        this.msgLog = logProvider.getLog(CheckPointerImpl.class);
        this.tracer = tracer;
    }

    @Override
    public void start() throws Throwable {
        this.threshold.initialize(this.transactionIdStore.getLastClosedTransactionId());
    }

    @Override
    public void forceCheckPoint() throws IOException {
        this.doCheckPoint(LogCheckPointEvent.NULL);
    }

    @Override
    public void checkPointIfNeeded() throws IOException {
        if (this.threshold.isCheckPointingNeeded(this.transactionIdStore.getLastClosedTransactionId())) {
            try (LogCheckPointEvent event = this.tracer.beginCheckPoint();){
                this.doCheckPoint(event);
            }
        }
    }

    private void doCheckPoint(LogCheckPointEvent logCheckPointEvent) throws IOException {
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        long lastClosedTransactionId = lastClosedTransaction[0];
        LogPosition logPosition = new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
        this.msgLog.info(CheckPointer.PrintFormat.prefix(lastClosedTransactionId) + "Starting check pointing...");
        this.kernelHealth.assertHealthy(IOException.class);
        this.msgLog.info(CheckPointer.PrintFormat.prefix(lastClosedTransactionId) + " Starting store flush...");
        this.storeFlusher.forceEverything();
        this.kernelHealth.assertHealthy(IOException.class);
        this.appender.checkPoint(logPosition, logCheckPointEvent);
        this.threshold.checkPointHappened(lastClosedTransactionId);
        this.msgLog.info(CheckPointer.PrintFormat.prefix(lastClosedTransactionId) + "Check pointing completed");
        this.logPruning.pruneLogs(logPosition.getLogVersion());
    }
}

