/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class CacheInvalidationTransactionApplier
extends NeoCommandHandler.Delegator {
    private final CacheAccessBackDoor cacheAccess;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final LabelTokenStore labelTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;

    public CacheInvalidationTransactionApplier(NeoCommandHandler delegate, NeoStore neoStore, CacheAccessBackDoor cacheAccess) {
        super(delegate);
        this.cacheAccess = cacheAccess;
        this.relationshipTypeTokenStore = neoStore.getRelationshipTypeTokenStore();
        this.labelTokenStore = neoStore.getLabelTokenStore();
        this.propertyKeyTokenStore = neoStore.getPropertyKeyTokenStore();
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        super.visitRelationshipTypeTokenCommand(command);
        RelationshipTypeToken type = (RelationshipTypeToken)this.relationshipTypeTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addRelationshipTypeToken(type);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        super.visitLabelTokenCommand(command);
        Object labelId = this.labelTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addLabelToken((Token)labelId);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        super.visitPropertyKeyTokenCommand(command);
        Object index = this.propertyKeyTokenStore.getToken((int)command.getKey());
        this.cacheAccess.addPropertyKeyToken((Token)index);
        return false;
    }
}

