/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public boolean storeFilesUpgradeable(File storeDirectory) {
        try {
            this.checkUpgradeable(storeDirectory);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public String checkUpgradeable(File storeDirectory) {
        StoreVersionCheck.Result result = this.checkUpgradeableFor(storeDirectory, "v0.A.0");
        if (result.outcome.isSuccessful()) {
            return "v0.A.0";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.1");
        if (result.outcome.isSuccessful()) {
            return "v0.A.1";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.3");
        if (result.outcome.isSuccessful()) {
            return "v0.A.3";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.5");
        if (result.outcome.isSuccessful()) {
            return "v0.A.5";
        }
        String path = new File(storeDirectory, result.storeFilename).getAbsolutePath();
        switch (result.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(path);
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(path);
            }
            case unexpectedUpgradingStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(path, "v0.A.3", result.actualVersion);
            }
        }
        throw new IllegalArgumentException(result.outcome.name());
    }

    private StoreVersionCheck.Result checkUpgradeableFor(File storeDirectory, String version) {
        StoreVersionCheck.Result result = null;
        for (StoreFile store : StoreFile.legacyStoreFilesForVersion(version)) {
            String expectedVersion = store.forVersion(version);
            File storeFile = new File(storeDirectory, store.storeFileName());
            result = this.storeVersionCheck.hasVersion(storeFile, expectedVersion);
            if (result.outcome.isSuccessful()) continue;
            break;
        }
        return result;
    }

    public boolean hasCurrentVersion(PageCache pageCache, File storeDir) {
        File neoStore = new File(storeDir, "neostore");
        long versionLong = NeoStore.getRecord(pageCache, neoStore, NeoStore.Position.STORE_VERSION);
        String versionAsString = NeoStore.versionLongToString(versionLong);
        return "v0.A.6".equals(versionAsString);
    }
}

