/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreMigrationTool {
    public static void main(String[] args) throws IOException {
        String legacyStoreDirectory = args[0];
        FormattedLogProvider userLogProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        new StoreMigrationTool().run((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File(legacyStoreDirectory), new Config(), (LogProvider)userLogProvider, StoreUpgrader.NO_MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final FileSystemAbstraction fs, final File legacyStoreDirectory, Config config, LogProvider userLogProvider, StoreUpgrader.Monitor monitor) throws IOException {
        ConfigMapUpgradeConfiguration upgradeConfiguration = new ConfigMapUpgradeConfiguration(config);
        StoreUpgrader migrationProcess = new StoreUpgrader(upgradeConfiguration, fs, monitor, userLogProvider);
        LifeSupport life = new LifeSupport();
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(fs, config);
        KernelContext kernelContext = new KernelContext(){

            @Override
            public FileSystemAbstraction fileSystem() {
                return fs;
            }

            @Override
            public File storeDir() {
                return legacyStoreDirectory;
            }
        };
        KernelExtensions kernelExtensions = life.add(new KernelExtensions(kernelContext, GraphDatabaseDependencies.newDependencies().kernelExtensions(), deps, UnsatisfiedDependencyStrategies.ignore()));
        StoreLogService logService = StoreLogService.withUserLogProvider(userLogProvider).inStoreDirectory(fs, legacyStoreDirectory);
        life.start();
        SchemaIndexProvider schemaIndexProvider = kernelExtensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        Log log = userLogProvider.getLog(StoreMigrationTool.class);
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache(fs, config);){
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(pageCache));
            migrationProcess.addParticipant(new StoreMigrator(new VisibleMigrationProgressMonitor(logService.getInternalLog(StoreMigrationTool.class)), fs, pageCache, upgradableDatabase, config, logService));
            migrationProcess.addParticipant(schemaIndexProvider.storeMigrationParticipant(fs, pageCache, upgradableDatabase));
            long startTime = System.currentTimeMillis();
            migrationProcess.migrateIfNeeded(legacyStoreDirectory, schemaIndexProvider);
            long duration = System.currentTimeMillis() - startTime;
            log.info(String.format("Migration completed in %d s%n", duration / 1000L));
        }
        catch (IOException e) {
            throw new StoreUpgrader.UnableToUpgradeException("Failure during upgrade", e);
        }
        catch (IllegalArgumentException e) {
        }
        finally {
            life.shutdown();
        }
    }
}

