/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class CurrentDatabase {
    private final StoreVersionCheck storeVersionCheck;
    private static final Map<String, String> fileNamesToTypeDescriptors = new HashMap<String, String>();

    public CurrentDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public boolean storeFilesAtCurrentVersion(File storeDirectory) {
        for (String fileName : fileNamesToTypeDescriptors.keySet()) {
            String expectedVersion = CommonAbstractStore.buildTypeDescriptorAndVersion(fileNamesToTypeDescriptors.get(fileName));
            if (this.storeVersionCheck.hasVersion((File)new File((File)storeDirectory, (String)fileName), (String)expectedVersion).outcome.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    static {
        fileNamesToTypeDescriptors.put("neostore", "NeoStore");
        fileNamesToTypeDescriptors.put("neostore.nodestore.db", "NodeStore");
        fileNamesToTypeDescriptors.put("neostore.propertystore.db", "PropertyStore");
        fileNamesToTypeDescriptors.put("neostore.propertystore.db.arrays", "ArrayPropertyStore");
        fileNamesToTypeDescriptors.put("neostore.propertystore.db.index", "PropertyIndexStore");
        fileNamesToTypeDescriptors.put("neostore.propertystore.db.index.keys", "StringPropertyStore");
        fileNamesToTypeDescriptors.put("neostore.propertystore.db.strings", "StringPropertyStore");
        fileNamesToTypeDescriptors.put("neostore.relationshipstore.db", "RelationshipStore");
        fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db", "RelationshipTypeStore");
        fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db.names", "StringPropertyStore");
    }
}

