/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenFactory;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public abstract class TokenStore<RECORD extends TokenRecord, TOKEN extends Token>
extends AbstractRecordStore<RECORD> {
    public static final int NAME_STORE_BLOCK_SIZE = 30;
    private DynamicStringStore nameStore;
    private final TokenFactory<TOKEN> tokenFactory;

    public TokenStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors, TokenFactory<TOKEN> tokenFactory) {
        super(fileName, configuration, idType, idGeneratorFactory, pageCache, fileSystemAbstraction, logProvider, versionMismatchHandler, monitors);
        this.nameStore = nameStore;
        this.tokenFactory = tokenFactory;
    }

    public DynamicStringStore getNameStore() {
        return this.nameStore;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    public void makeStoreOk() {
        this.nameStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void visitStore(Visitor<CommonAbstractStore, RuntimeException> visitor) {
        this.nameStore.visitStore(visitor);
        visitor.visit(this);
    }

    @Override
    protected void closeStorage() {
        if (this.nameStore != null) {
            this.nameStore.close();
            this.nameStore = null;
        }
    }

    @Override
    protected boolean doFastIdGeneratorRebuild() {
        return false;
    }

    public List<TOKEN> getTokens(int maxCount) {
        LinkedList<TOKEN> records = new LinkedList<TOKEN>();
        long maxIdInUse = this.getHighestPossibleIdInUse();
        int found = 0;
        int i = 0;
        while ((long)i <= maxIdInUse && found < maxCount) {
            block4: {
                RECORD record;
                try {
                    record = this.getRecord(i);
                }
                catch (InvalidRecordException t) {
                    break block4;
                }
                ++found;
                if (record != null && ((AbstractBaseRecord)record).inUse() && ((TokenRecord)record).getNameId() != Record.RESERVED.intValue()) {
                    records.add(this.tokenFactory.newToken(this.getStringFor(record), i));
                }
            }
            ++i;
        }
        return records;
    }

    public TOKEN getToken(int id) {
        RECORD record = this.getRecord(id);
        return (TOKEN)((Token)this.tokenFactory.newToken(this.getStringFor(record), ((AbstractRecord)record).getId()));
    }

    public RECORD getRecord(int id) {
        RECORD record = this.newRecord(id);
        byte inUseByte = Record.NOT_IN_USE.byteValue();
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            if (cursor.next()) {
                do {
                    inUseByte = this.getRecord(id, record, cursor);
                } while (cursor.shouldRetry());
            }
            if (inUseByte != Record.IN_USE.byteValue()) {
                throw new InvalidRecordException(this.getClass().getSimpleName() + " Record[" + id + "] not in use");
            }
            this.checkInUseByteValidity(id, inUseByte);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        ((TokenRecord)record).addNameRecords(this.nameStore.getLightRecords(((TokenRecord)record).getNameId()));
        return record;
    }

    @Override
    public RECORD getRecord(long id) {
        return this.getRecord((int)id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RECORD forceGetRecord(long id) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            if (cursor.next()) {
                byte inUseByte;
                RECORD record = this.newRecord((int)id);
                do {
                    inUseByte = this.getRecord((int)id, record, cursor);
                } while (cursor.shouldRetry());
                this.checkInUseByteValidity(id, inUseByte);
                ((TokenRecord)record).setIsLight(true);
                RECORD RECORD = record;
                return RECORD;
            }
            RECORD RECORD = this.newRecord((int)id);
            return RECORD;
        }
        catch (IOException e) {
            return this.newRecord((int)id);
        }
    }

    private void checkInUseByteValidity(long id, byte inUseByte) {
        if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
            throw new InvalidRecordException(this.getClass().getSimpleName() + " Record[" + id + "] unknown in use flag[" + inUseByte + "]");
        }
    }

    public Collection<DynamicRecord> allocateNameRecords(byte[] chars) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.nameStore.allocateRecordsFromBytes(records, chars);
        return records;
    }

    @Override
    public void updateRecord(RECORD record) {
        this.forceUpdateRecord(record);
        if (!((TokenRecord)record).isLight()) {
            for (DynamicRecord keyRecord : ((TokenRecord)record).getNameRecords()) {
                this.nameStore.updateRecord(keyRecord);
            }
        }
    }

    @Override
    public void forceUpdateRecord(RECORD record) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(((AbstractRecord)record).getId()), 2);){
            if (cursor.next()) {
                do {
                    this.updateRecord(record, cursor);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected abstract RECORD newRecord(int var1);

    protected byte getRecord(int id, RECORD record, PageCursor cursor) {
        cursor.setOffset(this.offsetForId(id));
        byte inUseByte = cursor.getByte();
        boolean inUse = inUseByte == Record.IN_USE.byteValue();
        ((AbstractBaseRecord)record).setInUse(inUse);
        if (inUse) {
            this.readRecord(record, cursor);
        }
        return inUseByte;
    }

    protected void readRecord(RECORD record, PageCursor cursor) {
        ((TokenRecord)record).setNameId(cursor.getInt());
    }

    protected void updateRecord(RECORD record, PageCursor cursor) {
        int id = ((AbstractRecord)record).getId();
        cursor.setOffset(this.offsetForId(id));
        if (((AbstractBaseRecord)record).inUse()) {
            cursor.putByte(Record.IN_USE.byteValue());
            this.writeRecord(record, cursor);
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
            this.freeId(id);
        }
    }

    protected void writeRecord(RECORD record, PageCursor cursor) {
        cursor.putInt(((TokenRecord)record).getNameId());
    }

    public void ensureHeavy(RECORD record) {
        if (!((TokenRecord)record).isLight()) {
            return;
        }
        ((TokenRecord)record).setIsLight(false);
        ((TokenRecord)record).addNameRecords(this.nameStore.getRecords(((TokenRecord)record).getNameId()));
    }

    public String getStringFor(RECORD nameRecord) {
        int recordToFind = ((TokenRecord)nameRecord).getNameId();
        Iterator<DynamicRecord> records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        ArrayList<DynamicRecord> relevantRecords = new ArrayList<DynamicRecord>();
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            recordToFind = (int)record.getNextBlock();
            relevantRecords.add(record);
            records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        }
        return PropertyStore.decodeString(this.nameStore.readFullByteArray(relevantRecords, PropertyType.STRING).other());
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

