/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class RelationshipTypeTokenStore
extends TokenStore<RelationshipTypeTokenRecord, RelationshipTypeToken> {
    public static final String TYPE_DESCRIPTOR = "RelationshipTypeStore";
    public static final int RECORD_SIZE = 5;

    public RelationshipTypeTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, config, IdType.RELATIONSHIP_TYPE_TOKEN, idGeneratorFactory, pageCache, fileSystemAbstraction, logProvider, nameStore, versionMismatchHandler, monitors, new RelationshipTypeToken.Factory());
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipTypeTokenRecord record) throws FAILURE {
        processor.processRelationshipTypeToken(this, record);
    }

    @Override
    protected RelationshipTypeTokenRecord newRecord(int id) {
        return new RelationshipTypeTokenRecord(id);
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected boolean isRecordReserved(PageCursor cursor) {
        return cursor.getInt() == Record.RESERVED.intValue();
    }
}

