/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreSingleRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private long relationshipId = -1L;
    private InstanceCache<StoreSingleRelationshipCursor> instanceCache;

    public StoreSingleRelationshipCursor(RelationshipRecord relationshipRecord, NeoStore neoStore, StoreStatement storeStatement, InstanceCache<StoreSingleRelationshipCursor> instanceCache) {
        super(relationshipRecord, neoStore, storeStatement);
        this.instanceCache = instanceCache;
    }

    public StoreSingleRelationshipCursor init(long relId) {
        this.relationshipId = relId;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        if (this.relationshipId != -1L) {
            try {
                this.relationshipRecord.setId(this.relationshipId);
                boolean bl = this.relationshipStore.fillRecord(this.relationshipId, this.relationshipRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.relationshipId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

