/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.io.IOException;
import java.util.LinkedList;
import org.neo4j.unsafe.impl.batchimport.executor.Task;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutor;
import org.neo4j.unsafe.impl.batchimport.store.io.JobMonitor;
import org.neo4j.unsafe.impl.batchimport.store.io.WriteJob;

class WriteQueue
implements Task<Void> {
    private final LinkedList<WriteJob> queue = new LinkedList();
    private final TaskExecutor<Void> executor;
    private final JobMonitor jobMonitor;

    public WriteQueue(TaskExecutor<Void> executor, JobMonitor jobMonitor) {
        this.executor = executor;
        this.jobMonitor = jobMonitor;
    }

    synchronized void offer(WriteJob job) {
        boolean wasEmpty = this.queue.isEmpty();
        this.queue.addLast(job);
        if (wasEmpty) {
            this.executor.submit(this);
            this.jobMonitor.jobQueued();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Void nothing) throws IOException {
        try {
            for (WriteJob job : this.drain()) {
                job.execute();
            }
        }
        finally {
            this.jobMonitor.jobExecuted();
        }
    }

    synchronized WriteJob[] drain() {
        WriteJob[] result = new WriteJob[this.queue.size()];
        this.queue.toArray(result);
        this.queue.clear();
        return result;
    }
}

