/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class CommandWriter
implements NeoCommandHandler {
    private final WritableLogChannel channel;

    public CommandWriter(WritableLogChannel channel) {
        this.channel = channel;
    }

    protected static byte needsLong(long value) {
        return value > Integer.MAX_VALUE ? (byte)1 : 0;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        this.channel.put((byte)1);
        this.channel.putLong(after.getId());
        this.writeNodeRecord(before);
        this.writeNodeRecord(after);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        RelationshipRecord record = command.getRecord();
        byte flags = Bits.bitFlags(Bits.bitFlag(record.inUse(), Record.IN_USE.byteValue()), Bits.bitFlag(record.isCreated(), (byte)2));
        this.channel.put((byte)3);
        this.channel.putLong(record.getId());
        this.channel.put(flags);
        if (record.inUse()) {
            this.channel.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp()).put((byte)((record.isFirstInFirstChain() ? 1 : 0) | (record.isFirstInSecondChain() ? 2 : 0)));
        } else {
            this.channel.putInt(record.getType());
        }
        return false;
    }

    private boolean writeNodeRecord(NodeRecord record) throws IOException {
        byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        this.channel.put(inUse);
        if (record.inUse()) {
            this.channel.put(record.isDense() ? (byte)1 : 0);
            this.channel.putLong(record.getNextRel()).putLong(record.getNextProp());
            this.channel.putLong(record.getLabelField());
        }
        this.writeDynamicRecords(record.getDynamicLabelRecords());
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        this.channel.put((byte)2);
        this.channel.putLong(command.getKey());
        this.writePropertyRecord(command.getBefore());
        this.writePropertyRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        RelationshipGroupRecord record = command.getRecord();
        this.channel.put((byte)9);
        this.channel.putLong(record.getId());
        this.channel.put((byte)(record.inUse() ? Record.IN_USE.intValue() : Record.NOT_IN_USE.intValue()));
        this.channel.putShort((short)record.getType());
        this.channel.putLong(record.getNext());
        this.channel.putLong(record.getFirstOut());
        this.channel.putLong(record.getFirstIn());
        this.channel.putLong(record.getFirstLoop());
        this.channel.putLong(record.getOwningNode());
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        RelationshipTypeTokenRecord record = (RelationshipTypeTokenRecord)command.getRecord();
        byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        this.channel.put((byte)4);
        this.channel.putInt(record.getId()).put(inUse).putInt(record.getNameId());
        this.writeDynamicRecords(record.getNameRecords());
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        LabelTokenRecord record = (LabelTokenRecord)command.getRecord();
        byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        this.channel.put((byte)8);
        this.channel.putInt(record.getId()).put(inUse).putInt(record.getNameId());
        this.writeDynamicRecords(record.getNameRecords());
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        PropertyKeyTokenRecord record = (PropertyKeyTokenRecord)command.getRecord();
        byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        this.channel.put((byte)5);
        this.channel.putInt(record.getId());
        this.channel.put(inUse);
        this.channel.putInt(record.getPropertyCount()).putInt(record.getNameId());
        if (record.isLight()) {
            this.channel.putInt(0);
        } else {
            this.writeDynamicRecords(record.getNameRecords());
        }
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        Collection<DynamicRecord> recordsBefore = command.getRecordsBefore();
        Collection<DynamicRecord> recordsAfter = command.getRecordsAfter();
        this.channel.put((byte)7);
        this.writeDynamicRecords(recordsBefore);
        this.writeDynamicRecords(recordsAfter);
        this.channel.put(IteratorUtil.first(recordsAfter).isCreated() ? (byte)1 : 0);
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.channel.put((byte)6).putLong(command.getRecord().getNextProp());
        return false;
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        this.channel.put((byte)11);
        this.writeToFile(command);
        return false;
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        this.channel.put((byte)12);
        this.writeToFile(command);
        this.putIntOrLong(command.getStartNode());
        this.putIntOrLong(command.getEndNode());
        return false;
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        this.channel.put((byte)13);
        this.writeToFile(command);
        return false;
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        this.channel.put((byte)14);
        this.writeIndexCommandHeader(command);
        return false;
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        this.channel.put((byte)15);
        this.writeIndexCommandHeader(command);
        this.channel.putShort((short)command.getConfig().size());
        for (Map.Entry<String, String> entry : command.getConfig().entrySet()) {
            IoPrimitiveUtils.write2bLengthAndString(this.channel, entry.getKey());
            IoPrimitiveUtils.write2bLengthAndString(this.channel, entry.getValue());
        }
        return false;
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        this.channel.put((byte)10);
        byte zero = 0;
        this.writeIndexCommandHeader(zero, zero, zero, zero, zero, zero, zero);
        this.writeMap(command.getIndexNameIdRange());
        this.writeMap(command.getKeyIdRange());
        return false;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
        this.channel.put((byte)17);
        this.channel.putInt(command.labelId()).putLong(command.delta());
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        this.channel.put((byte)16);
        this.channel.putInt(command.startLabelId()).putInt(command.typeId()).putInt(command.endLabelId()).putLong(command.delta());
        return false;
    }

    private void writeMap(Map<String, Integer> map) throws IOException {
        this.channel.put((byte)map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            IoPrimitiveUtils.write2bLengthAndString(this.channel, entry.getKey());
            int id = entry.getValue();
            this.channel.putShort((short)id);
        }
    }

    public void writeToFile(IndexCommand command) throws IOException {
        this.writeIndexCommandHeader(command);
        this.putIntOrLong(command.getEntityId());
        Object value = command.getValue();
        switch (command.getValueType()) {
            case 6: {
                IoPrimitiveUtils.write3bLengthAndString(this.channel, value.toString());
                break;
            }
            case 1: {
                this.channel.putShort(((Number)value).shortValue());
                break;
            }
            case 2: {
                this.channel.putInt(((Number)value).intValue());
                break;
            }
            case 3: {
                this.channel.putLong(((Number)value).longValue());
                break;
            }
            case 4: {
                this.channel.putFloat(((Number)value).floatValue());
                break;
            }
            case 5: {
                this.channel.putDouble(((Number)value).doubleValue());
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown value type " + command.getValueType());
            }
        }
    }

    protected void writeIndexCommandHeader(IndexCommand command) throws IOException {
        this.writeIndexCommandHeader(command.getValueType(), command.getEntityType(), CommandWriter.needsLong(command.getEntityId()), command.startNodeNeedsLong(), command.endNodeNeedsLong(), command.getIndexNameId(), command.getKeyId());
    }

    protected void writeIndexCommandHeader(byte valueType, byte entityType, byte entityIdNeedsLong, byte startNodeNeedsLong, byte endNodeNeedsLong, int indexNameId, int keyId) throws IOException {
        this.channel.put((byte)(valueType << 2 | entityType << 1 | entityIdNeedsLong));
        this.channel.put((byte)(startNodeNeedsLong << 7 | endNodeNeedsLong << 6));
        this.channel.putShort((short)indexNameId);
        this.channel.putShort((short)keyId);
    }

    protected void putIntOrLong(long id) throws IOException {
        if (CommandWriter.needsLong(id) == 1) {
            this.channel.putLong(id);
        } else {
            this.channel.putInt((int)id);
        }
    }

    void writeDynamicRecords(Collection<DynamicRecord> records) throws IOException {
        this.channel.putInt(records.size());
        for (DynamicRecord record : records) {
            this.writeDynamicRecord(record);
        }
    }

    void writeDynamicRecord(DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            if (record.isStartRecord()) {
                inUse = (byte)(inUse | Record.FIRST_IN_CHAIN.byteValue());
            }
            this.channel.putLong(record.getId()).putInt(record.getType()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
            byte[] data = record.getData();
            assert (data != null);
            this.channel.put(data, data.length);
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            this.channel.putLong(record.getId()).putInt(record.getType()).put(inUse);
        }
    }

    private void writePropertyBlock(PropertyBlock block) throws IOException {
        long[] propBlockValues;
        byte blockSize = (byte)block.getSize();
        assert (blockSize > 0) : blockSize + " is not a valid block size value";
        this.channel.put(blockSize);
        for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
            this.channel.putLong(propBlockValue);
        }
        if (block.isLight()) {
            this.channel.putInt(0);
        } else {
            this.writeDynamicRecords(block.getValueRecords());
        }
    }

    private void writePropertyRecord(PropertyRecord record) throws IOException {
        byte inUse;
        byte by = inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
        if (record.getRelId() != -1L) {
            inUse = (byte)(inUse + Record.REL_PROPERTY.byteValue());
        }
        this.channel.put(inUse);
        this.channel.putLong(record.getNextProp()).putLong(record.getPrevProp());
        long nodeId = record.getNodeId();
        long relId = record.getRelId();
        if (nodeId != -1L) {
            this.channel.putLong(nodeId);
        } else if (relId != -1L) {
            this.channel.putLong(relId);
        } else {
            this.channel.putLong(-1L);
        }
        this.channel.put((byte)record.numberOfProperties());
        for (PropertyBlock block : record) {
            assert (block.getSize() > 0) : record + " seems kinda broken";
            this.writePropertyBlock(block);
        }
        this.writeDynamicRecords(record.getDeletedRecords());
    }

    @Override
    public void apply() {
    }

    @Override
    public void close() {
    }
}

