/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class StoreVersionCheck {
    private final FileSystemAbstraction fs;

    public StoreVersionCheck(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result hasVersion(File storeFile, String expectedVersion) {
        StoreChannel fileChannel = null;
        String storeFilename = storeFile.getName();
        byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
        try {
            if (!this.fs.fileExists(storeFile)) {
                Result result = new Result(Result.Outcome.missingStoreFile, null, storeFilename);
                return result;
            }
            fileChannel = this.fs.open(storeFile, "r");
            if (fileChannel.size() < (long)expectedVersionBytes.length) {
                Result result = new Result(Result.Outcome.storeVersionNotFound, null, storeFilename);
                return result;
            }
            String actualVersion = this.readVersion(fileChannel, expectedVersionBytes.length);
            if (!actualVersion.startsWith(this.typeDescriptor(expectedVersion))) {
                Result result = new Result(Result.Outcome.storeVersionNotFound, actualVersion, storeFilename);
                return result;
            }
            if (expectedVersion.equals(actualVersion)) return new Result(Result.Outcome.ok, null, storeFilename);
            Result result = new Result(Result.Outcome.unexpectedUpgradingStoreVersion, actualVersion, storeFilename);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String typeDescriptor(String expectedVersion) {
        int spaceIndex = expectedVersion.indexOf(32);
        if (spaceIndex == -1) {
            throw new IllegalArgumentException("Unexpected version " + expectedVersion);
        }
        return expectedVersion.substring(0, spaceIndex);
    }

    private String readVersion(StoreChannel fileChannel, int bytesToRead) throws IOException {
        fileChannel.position(fileChannel.size() - (long)bytesToRead);
        byte[] foundVersionBytes = new byte[bytesToRead];
        fileChannel.read(ByteBuffer.wrap(foundVersionBytes));
        return UTF8.decode(foundVersionBytes);
    }

    public static class Result {
        public final Outcome outcome;
        public final String actualVersion;
        public final String storeFilename;

        public Result(Outcome outcome, String actualVersion, String storeFilename) {
            this.outcome = outcome;
            this.actualVersion = actualVersion;
            this.storeFilename = storeFilename;
        }

        public static enum Outcome {
            ok(true),
            missingStoreFile(false),
            storeVersionNotFound(false),
            unexpectedUpgradingStoreVersion(false);

            private final boolean success;

            private Outcome(boolean success) {
                this.success = success;
            }

            public boolean isSuccessful() {
                return this.success;
            }
        }
    }
}

