/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.helpers.ObjectUtil;
import org.neo4j.kernel.api.properties.ArrayValue;
import org.neo4j.kernel.api.properties.LazyProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.cache.SizeOfObject;

public abstract class DefinedProperty
extends Property
implements SizeOfObject {
    private static final long NON_DOUBLE_LONG = -9007199254740992L;

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public abstract Object value();

    @Override
    public Object value(Object defaultValue) {
        return this.value();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[propertyKeyId=" + this.propertyKeyId() + ", value=" + this.valueAsString() + "]";
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefinedProperty) {
            DefinedProperty that = (DefinedProperty)o;
            if (this.propertyKeyId == that.propertyKeyId) {
                if (o instanceof LazyProperty) {
                    return that.valueEquals(this.value());
                }
                return this.hasEqualValue(that);
            }
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.propertyKeyId ^ this.valueHash();
    }

    abstract int valueHash();

    abstract boolean hasEqualValue(DefinedProperty var1);

    @Override
    public String valueAsString() {
        return ObjectUtil.toString(this.value());
    }

    DefinedProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    static boolean numbersEqual(double fpn, long in) {
        if (in < 0L) {
            if (fpn < 0.0) {
                if ((0xFFE0000000000000L & in) == -9007199254740992L) {
                    return fpn == (double)in;
                }
                if (fpn < -9.223372036854776E18) {
                    return false;
                }
                if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                    return in == (long)fpn;
                }
            }
        } else if (!(fpn < 0.0)) {
            if ((0xFFE0000000000000L & in) == 0L) {
                return fpn == (double)in;
            }
            if (fpn > 9.223372036854776E18) {
                return false;
            }
            if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                return in == (long)fpn;
            }
        }
        return false;
    }

    static boolean numbersEqual(ArrayValue.IntegralArray lhs, ArrayValue.IntegralArray rhs) {
        int length = lhs.length();
        if (length != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs.longValue(i) == rhs.longValue(i)) continue;
            return false;
        }
        return true;
    }

    static boolean numbersEqual(ArrayValue.FloatingPointArray lhs, ArrayValue.FloatingPointArray rhs) {
        int length = lhs.length();
        if (length != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs.doubleValue(i) == rhs.doubleValue(i)) continue;
            return false;
        }
        return true;
    }

    static boolean numbersEqual(ArrayValue.FloatingPointArray fps, ArrayValue.IntegralArray ins) {
        int length = ins.length();
        if (length != fps.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (DefinedProperty.numbersEqual(fps.doubleValue(i), ins.longValue(i))) continue;
            return false;
        }
        return true;
    }
}

