/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class ReadOnlyTransactionIdStore
implements TransactionIdStore {
    private final long transactionId;
    private final long transactionChecksum;

    public ReadOnlyTransactionIdStore(FileSystemAbstraction fs, File storeDir) {
        long id = 0L;
        long checksum = 0L;
        if (NeoStoreUtil.neoStoreExists(fs, storeDir)) {
            NeoStoreUtil access = new NeoStoreUtil(storeDir, fs);
            id = access.getLastCommittedTx();
            checksum = access.getLastCommittedTxChecksum();
        }
        this.transactionId = id;
        this.transactionChecksum = checksum;
    }

    @Override
    public long nextCommittingTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionCommitted(long transactionId, long checksum) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.transactionId;
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        return new TransactionId(this.transactionId, this.transactionChecksum);
    }

    @Override
    public TransactionId getUpgradeTransaction() {
        return this.getLastCommittedTransaction();
    }

    @Override
    public long getLastClosedTransactionId() {
        return this.transactionId;
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void transactionClosed(long transactionId) {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        throw new UnsupportedOperationException("Read-only transaction ID store");
    }

    @Override
    public void flush() {
    }
}

