/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class PhysicalLogNeoCommandReaderV2_2_4
implements CommandReader,
NeoCommandHandler {
    private ReadableLogChannel channel;
    private IndexCommandHeader indexCommandHeader;

    @Override
    public Command read(ReadableLogChannel channel) throws IOException {
        this.channel = channel;
        byte commandType = 0;
        while (commandType == 0) {
            commandType = channel.get();
        }
        Command command = this.instantiateCommand(channel, commandType);
        if (command.handle(this)) {
            return null;
        }
        return command;
    }

    private Command instantiateCommand(ReadableLogChannel channel, byte commandType) throws IOException {
        switch (commandType) {
            case 1: {
                return new Command.NodeCommand();
            }
            case 2: {
                return new Command.PropertyCommand();
            }
            case 5: {
                return new Command.PropertyKeyTokenCommand();
            }
            case 3: {
                return new Command.RelationshipCommand();
            }
            case 4: {
                return new Command.RelationshipTypeTokenCommand();
            }
            case 8: {
                return new Command.LabelTokenCommand();
            }
            case 6: {
                return new Command.NeoStoreCommand();
            }
            case 7: {
                return new Command.SchemaRuleCommand();
            }
            case 9: {
                return new Command.RelationshipGroupCommand();
            }
            case 10: {
                return new IndexDefineCommand();
            }
            case 11: {
                return new IndexCommand.AddNodeCommand();
            }
            case 12: {
                return new IndexCommand.AddRelationshipCommand();
            }
            case 13: {
                return new IndexCommand.RemoveCommand();
            }
            case 14: {
                return new IndexCommand.DeleteCommand();
            }
            case 15: {
                return new IndexCommand.CreateCommand();
            }
            case 16: {
                return new Command.RelationshipCountsCommand();
            }
            case 17: {
                return new Command.NodeCountsCommand();
            }
        }
        LogPositionMarker position = new LogPositionMarker();
        channel.getCurrentPosition(position);
        throw new IOException("Unknown command type[" + commandType + "] near " + position.newPosition());
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        long id = this.channel.getLong();
        NodeRecord before = this.readNodeRecord(id);
        if (before == null) {
            return true;
        }
        NodeRecord after = this.readNodeRecord(id);
        if (after == null) {
            return true;
        }
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        command.init(before, after);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        RelationshipRecord record;
        long id = this.channel.getLong();
        byte flags = this.channel.get();
        boolean inUse = false;
        if (Bits.notFlag(Bits.notFlag(flags, Record.IN_USE.byteValue()), (byte)2) != 0) {
            throw new IOException("Illegal in use flag: " + flags);
        }
        if (Bits.bitFlag(flags, Record.IN_USE.byteValue())) {
            inUse = true;
        }
        if (inUse) {
            record = new RelationshipRecord(id, this.channel.getLong(), this.channel.getLong(), this.channel.getInt());
            record.setInUse(true);
            record.setFirstPrevRel(this.channel.getLong());
            record.setFirstNextRel(this.channel.getLong());
            record.setSecondPrevRel(this.channel.getLong());
            record.setSecondNextRel(this.channel.getLong());
            record.setNextProp(this.channel.getLong());
            byte extraByte = this.channel.get();
            record.setFirstInFirstChain((extraByte & 1) > 0);
            record.setFirstInSecondChain((extraByte & 2) > 0);
        } else {
            record = new RelationshipRecord(id, -1L, -1L, this.channel.getInt());
            record.setInUse(false);
        }
        if (Bits.bitFlag(flags, (byte)2)) {
            record.setCreated();
        }
        command.init(record);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        long id = this.channel.getLong();
        PropertyRecord before = this.readPropertyRecord(id);
        if (before == null) {
            return true;
        }
        PropertyRecord after = this.readPropertyRecord(id);
        if (after == null) {
            return true;
        }
        command.init(before, after);
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        boolean inUse;
        long id = this.channel.getLong();
        byte inUseByte = this.channel.get();
        boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
        if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseByte);
        }
        short type = this.channel.getShort();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
        record.setInUse(inUse);
        record.setNext(this.channel.getLong());
        record.setFirstOut(this.channel.getLong());
        record.setFirstIn(this.channel.getLong());
        record.setFirstLoop(this.channel.getLong());
        record.setOwningNode(this.channel.getLong());
        command.init(record);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        int id = this.channel.getInt();
        byte inUseFlag = this.channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(this.channel.getInt());
        int nrTypeRecords = this.channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord();
            if (dr == null) {
                return true;
            }
            record.addNameRecord(dr);
        }
        command.init(record);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        int id = this.channel.getInt();
        byte inUseFlag = this.channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(this.channel.getInt());
        int nrTypeRecords = this.channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord();
            if (dr == null) {
                return true;
            }
            record.addNameRecord(dr);
        }
        command.init(record);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        int id = this.channel.getInt();
        byte inUseFlag = this.channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(this.channel.getInt());
        record.setNameId(this.channel.getInt());
        if (this.readDynamicRecords(record, CommandReaderFactory.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER) == -1) {
            return true;
        }
        command.init(record);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
        this.readDynamicRecords(recordsBefore, CommandReaderFactory.COLLECTION_DYNAMIC_RECORD_ADDER);
        ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
        this.readDynamicRecords(recordsAfter, CommandReaderFactory.COLLECTION_DYNAMIC_RECORD_ADDER);
        byte isCreated = this.channel.get();
        if (1 == isCreated) {
            for (DynamicRecord record : recordsAfter) {
                record.setCreated();
            }
        }
        SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? this.readSchemaRule(recordsAfter) : this.readSchemaRule(recordsBefore);
        command.init(recordsBefore, recordsAfter, rule);
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        long nextProp = this.channel.getLong();
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(nextProp);
        command.init(record);
        return false;
    }

    private NodeRecord readNodeRecord(long id) throws IOException {
        NodeRecord record;
        byte inUseFlag = this.channel.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
        long labelField = Record.NO_LABELS_FIELD.intValue();
        if (inUse) {
            boolean dense = this.channel.get() == 1;
            record = new NodeRecord(id, dense, this.channel.getLong(), this.channel.getLong());
            labelField = this.channel.getLong();
        } else {
            record = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        this.readDynamicRecords(dynamicLabelRecords, CommandReaderFactory.COLLECTION_DYNAMIC_RECORD_ADDER);
        record.setLabelField(labelField, dynamicLabelRecords);
        record.setInUse(inUse);
        return record;
    }

    DynamicRecord readDynamicRecord() throws IOException {
        long id = this.channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = this.channel.getInt();
        byte inUseFlag = this.channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
            int nrOfBytes = this.channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of " + "a dynamic record";
            long nextBlock = this.channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of " + "a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            this.channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    <T> int readDynamicRecords(T target, CommandReaderFactory.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = this.channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = this.readDynamicRecord();
            if (read == null) {
                return -1;
            }
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private PropertyRecord readPropertyRecord(long id) throws IOException {
        long primitiveId;
        PropertyRecord record = new PropertyRecord(id);
        byte inUseFlag = this.channel.get();
        long nextProp = this.channel.getLong();
        long prevProp = this.channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        }
        boolean nodeProperty = true;
        if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
            nodeProperty = false;
        }
        if ((primitiveId = this.channel.getLong()) != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        int nrPropBlocks = this.channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = this.readPropertyBlock();
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        int deletedRecords = this.readDynamicRecords(record, CommandReaderFactory.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER);
        if (deletedRecords == -1) {
            return null;
        }
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = this.readDynamicRecord();
            if (read == null) {
                return null;
            }
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    PropertyBlock readPropertyBlock() throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = this.channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = this.readLongs(blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        if (this.readDynamicRecords(toReturn, CommandReaderFactory.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private long[] readLongs(int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.channel.getLong();
        }
        return result;
    }

    private SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
        SchemaRule rule;
        ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
        try {
            rule = SchemaRule.Kind.deserialize(IteratorUtil.first(recordsBefore).getId(), deserialized);
        }
        catch (MalformedSchemaRuleException e) {
            return null;
        }
        return rule;
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        IndexCommandHeader header = this.readIndexCommandHeader();
        Long entityId = header.entityIdNeedsLong ? this.channel.getLong() : (long)this.channel.getInt();
        Object value = this.readIndexValue(header.valueType);
        command.init(header.indexNameId, entityId, header.keyId, value);
        return false;
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        IndexCommandHeader header = this.readIndexCommandHeader();
        Long entityId = header.entityIdNeedsLong ? this.channel.getLong() : (long)this.channel.getInt();
        Object value = this.readIndexValue(header.valueType);
        Long startNode = header.startNodeNeedsLong ? this.channel.getLong() : (long)this.channel.getInt();
        Long endNode = header.endNodeNeedsLong ? this.channel.getLong() : (long)this.channel.getInt();
        command.init(header.indexNameId, entityId, header.keyId, value, startNode, endNode);
        return false;
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        IndexCommandHeader header = this.readIndexCommandHeader();
        Long entityId = header.entityIdNeedsLong ? this.channel.getLong() : (long)this.channel.getInt();
        Object value = this.readIndexValue(header.valueType);
        command.init(header.indexNameId, header.entityType, entityId, header.keyId, value);
        return false;
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand deleteCommand) throws IOException {
        IndexCommandHeader header = this.readIndexCommandHeader();
        deleteCommand.init(header.indexNameId, header.entityType);
        return false;
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand createCommand) throws IOException {
        IndexCommandHeader header = this.readIndexCommandHeader();
        Map<String, String> config = IoPrimitiveUtils.read2bMap(this.channel);
        createCommand.init(header.indexNameId, header.entityType, config);
        return false;
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand indexDefineCommand) throws IOException {
        this.readIndexCommandHeader();
        Map<String, Integer> indexNames = this.readMap(this.channel);
        Map<String, Integer> keys = this.readMap(this.channel);
        indexDefineCommand.init(indexNames, keys);
        return false;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
        int labelId = this.channel.getInt();
        long delta = this.channel.getLong();
        command.init(labelId, delta);
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        int startLabelId = this.channel.getInt();
        int typeId = this.channel.getInt();
        int endLabelId = this.channel.getInt();
        long delta = this.channel.getLong();
        command.init(startLabelId, typeId, endLabelId, delta);
        return false;
    }

    private Map<String, Integer> readMap(ReadableLogChannel channel) throws IOException {
        int size = channel.get();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            String key = IoPrimitiveUtils.read2bLengthAndString(channel);
            int id = this.getUnsignedShort(channel);
            if (key == null) {
                return null;
            }
            result.put(key, id);
        }
        return result;
    }

    private int getUnsignedShort(ReadableLogChannel channel) throws IOException {
        int result = channel.getShort() & 0xFFFF;
        return result == 65535 ? -1 : result;
    }

    private IndexCommandHeader readIndexCommandHeader() throws ReadPastEndException, IOException {
        byte firstHeaderByte = this.channel.get();
        byte valueType = (byte)((firstHeaderByte & 0x1C) >> 2);
        byte entityType = (byte)((firstHeaderByte & 2) >> 1);
        boolean entityIdNeedsLong = (firstHeaderByte & 1) > 0;
        byte secondHeaderByte = this.channel.get();
        boolean startNodeNeedsLong = (secondHeaderByte & 0x80) > 0;
        boolean endNodeNeedsLong = (secondHeaderByte & 0x40) > 0;
        int indexNameId = this.getUnsignedShort(this.channel);
        int keyId = this.getUnsignedShort(this.channel);
        if (this.indexCommandHeader == null) {
            this.indexCommandHeader = new IndexCommandHeader();
        }
        return this.indexCommandHeader.set(valueType, entityType, entityIdNeedsLong, indexNameId, startNodeNeedsLong, endNodeNeedsLong, keyId);
    }

    private Object readIndexValue(byte valueType) throws IOException {
        switch (valueType) {
            case 0: {
                return null;
            }
            case 1: {
                return this.channel.getShort();
            }
            case 2: {
                return this.channel.getInt();
            }
            case 3: {
                return this.channel.getLong();
            }
            case 4: {
                return Float.valueOf(this.channel.getFloat());
            }
            case 5: {
                return this.channel.getDouble();
            }
            case 6: {
                return IoPrimitiveUtils.read3bLengthAndString(this.channel);
            }
        }
        throw new RuntimeException("Unknown value type " + valueType);
    }

    @Override
    public void apply() {
    }

    @Override
    public void close() {
    }

    private static final class IndexCommandHeader {
        byte valueType;
        byte entityType;
        boolean entityIdNeedsLong;
        int indexNameId;
        boolean startNodeNeedsLong;
        boolean endNodeNeedsLong;
        int keyId;

        private IndexCommandHeader() {
        }

        IndexCommandHeader set(byte valueType, byte entityType, boolean entityIdNeedsLong, int indexNameId, boolean startNodeNeedsLong, boolean endNodeNeedsLong, int keyId) {
            this.valueType = valueType;
            this.entityType = entityType;
            this.entityIdNeedsLong = entityIdNeedsLong;
            this.indexNameId = indexNameId;
            this.startNodeNeedsLong = startNodeNeedsLong;
            this.endNodeNeedsLong = endNodeNeedsLong;
            this.keyId = keyId;
            return this;
        }
    }
}

