/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public interface RecordStore<R extends AbstractBaseRecord>
extends IdSequence {
    public static final Predicate<AbstractBaseRecord> IN_USE = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean accept(AbstractBaseRecord item) {
            return item.inUse();
        }
    };

    public File getStorageFileName();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public R getRecord(long var1);

    public Long getNextRecordReference(R var1);

    public Collection<R> getRecords(long var1);

    public void updateRecord(R var1);

    public R forceGetRecord(long var1);

    public R forceGetRaw(R var1);

    public R forceGetRaw(long var1);

    public void forceUpdateRecord(R var1);

    public <FAILURE extends Exception> void accept(Processor<FAILURE> var1, R var2) throws FAILURE;

    public int getRecordSize();

    public int getRecordHeaderSize();

    public void close();

    public int getNumberOfReservedLowIds();

    public static class Scanner {
        @SafeVarargs
        public static <R extends AbstractBaseRecord> Iterable<R> scan(final RecordStore<R> store, final Predicate<? super R> ... filters) {
            return new Iterable<R>(){

                @Override
                public Iterator<R> iterator() {
                    return new PrefetchingIterator<R>(){
                        final PrimitiveLongIterator ids;
                        {
                            this.ids = new StoreIdIterator(store);
                        }

                        @Override
                        protected R fetchNextOrNull() {
                            block0: while (this.ids.hasNext()) {
                                Object record = store.forceGetRecord(this.ids.next());
                                for (Predicate filter : filters) {
                                    if (!filter.accept(record)) continue block0;
                                }
                                return record;
                            }
                            return null;
                        }
                    };
                }
            };
        }

        public static <R extends AbstractBaseRecord> Iterable<R> scanById(final RecordStore<R> store, Iterable<Long> ids) {
            return new IterableWrapper<R, Long>(ids){

                @Override
                protected R underlyingObjectToObject(Long id) {
                    return store.forceGetRecord(id);
                }
            };
        }
    }

    public static abstract class Processor<FAILURE extends Exception> {
        private volatile boolean shouldStop;

        public void stop() {
            this.shouldStop = true;
        }

        public abstract void processSchema(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processNode(RecordStore<NodeRecord> var1, NodeRecord var2) throws FAILURE;

        public abstract void processRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2) throws FAILURE;

        public abstract void processProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2) throws FAILURE;

        public abstract void processString(RecordStore<DynamicRecord> var1, DynamicRecord var2, IdType var3) throws FAILURE;

        public abstract void processArray(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processLabelArrayWithOwner(RecordStore<DynamicRecord> var1, DynamicRecord var2) throws FAILURE;

        public abstract void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2) throws FAILURE;

        public abstract void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2) throws FAILURE;

        public abstract void processLabelToken(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2) throws FAILURE;

        public abstract void processRelationshipGroup(RecordStore<RelationshipGroupRecord> var1, RelationshipGroupRecord var2) throws FAILURE;

        protected <R extends AbstractBaseRecord> R getRecord(RecordStore<R> store, long id) {
            return store.forceGetRecord(id);
        }

        public <R extends AbstractBaseRecord> void applyById(RecordStore<R> store, Iterable<Long> ids) throws FAILURE {
            for (AbstractBaseRecord record : Scanner.scanById(store, ids)) {
                store.accept(this, record);
            }
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, ProgressListener.NONE, filters);
        }

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, progressListener, filters);
        }

        private <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, Predicate<? super R> ... filters) throws FAILURE {
            for (AbstractBaseRecord record : Scanner.scan(store, filters)) {
                if (this.shouldStop) break;
                store.accept(this, record);
                progressListener.set(record.getLongId());
            }
            progressListener.done();
        }
    }
}

