/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.kernel.impl.util.SequenceArray;

public class ArrayQueueOutOfOrderSequence
implements OutOfOrderSequence {
    private volatile int version;
    private long highestGapFreeNumber;
    private long highestGapFreeMeta;
    private final SequenceArray outOfOrderQueue;
    private final long[] metaArray = new long[1];

    public ArrayQueueOutOfOrderSequence(long startingNumber, int initialArraySize) {
        this.highestGapFreeNumber = startingNumber;
        this.outOfOrderQueue = new SequenceArray(2, initialArraySize);
    }

    @Override
    public synchronized boolean offer(long number, long meta) {
        if (this.highestGapFreeNumber + 1L == number) {
            ++this.version;
            this.highestGapFreeNumber = this.outOfOrderQueue.pollHighestGapFree(number, this.metaArray);
            this.highestGapFreeMeta = this.highestGapFreeNumber == number ? meta : this.metaArray[0];
            ++this.version;
            return true;
        }
        this.outOfOrderQueue.offer(this.highestGapFreeNumber, number, this.pack(meta));
        return false;
    }

    private long[] pack(long meta) {
        this.metaArray[0] = meta;
        return this.metaArray;
    }

    @Override
    public long[] get() {
        long number = 0L;
        long meta = 0L;
        while (true) {
            int versionBefore;
            if (((versionBefore = this.version) & 1) == 1) {
                continue;
            }
            number = this.highestGapFreeNumber;
            meta = this.highestGapFreeMeta;
            if (this.version == versionBefore) break;
        }
        return new long[]{number, meta};
    }

    @Override
    public long getHighestGapFreeNumber() {
        return this.highestGapFreeNumber;
    }

    @Override
    public synchronized boolean seen(long number, long meta) {
        if (number < this.highestGapFreeNumber) {
            return true;
        }
        if (number == this.highestGapFreeNumber) {
            return this.highestGapFreeMeta == meta;
        }
        return this.outOfOrderQueue.seen(this.highestGapFreeNumber, number, new long[]{meta});
    }

    @Override
    public synchronized void set(long number, long meta) {
        this.highestGapFreeNumber = number;
        this.highestGapFreeMeta = meta;
        this.outOfOrderQueue.clear();
    }

    public synchronized String toString() {
        return String.format("out-of-order-sequence:%d [%s]", this.highestGapFreeNumber, this.outOfOrderQueue);
    }
}

