/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.PropertyUniqueConstraintCreator;

public class BaseConstraintCreator
implements ConstraintCreator {
    protected final InternalSchemaActions actions;
    protected final Label label;

    public BaseConstraintCreator(InternalSchemaActions actions, Label label) {
        this.actions = actions;
        this.label = label;
        this.assertInUnterminatedTransaction();
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        return new PropertyUniqueConstraintCreator(this.actions, this.label, propertyKey);
    }

    @Override
    public ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("No constraint assertions specified");
    }

    protected final void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }
}

