/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipCountsProcessor
implements RecordProcessor<RelationshipRecord> {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private final NodeLabelsCache nodeLabelCache;
    private final LongArray counts;
    private int[] startScratch = new int[20];
    private int[] endScratch = new int[20];
    private final CountsAccessor.Updater countsUpdater;
    private final int anyLabel;
    private final int anyRelationshipType;
    private final NodeLabelsCache.Client client;
    private final int itemsPerType;
    private final int itemsPerStartLabel;

    public RelationshipCountsProcessor(NodeLabelsCache nodeLabelCache, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory) {
        this.nodeLabelCache = nodeLabelCache;
        this.client = nodeLabelCache.newClient();
        this.countsUpdater = countsUpdater;
        this.anyLabel = highLabelId;
        this.anyRelationshipType = highRelationshipTypeId;
        this.itemsPerType = this.anyLabel + 1;
        this.itemsPerStartLabel = (this.anyRelationshipType + 1) * this.itemsPerType;
        this.counts = cacheFactory.newLongArray(this.arrayIndex(highLabelId, highRelationshipTypeId, highLabelId) + 1, 0L);
    }

    private int arrayIndex(int startLabel, int relationshipType, int endLabel) {
        return startLabel * this.itemsPerStartLabel + relationshipType * this.itemsPerType + endLabel;
    }

    private void increment(int startLabel, int relationshipType, int endLabel) {
        int index = this.arrayIndex(startLabel, relationshipType, endLabel);
        this.counts.set(index, this.counts.get(index) + 1L);
    }

    public void process(long startNode, int type, long endNode) {
        this.increment(this.anyLabel, this.anyRelationshipType, this.anyLabel);
        this.increment(this.anyLabel, type, this.anyLabel);
        for (int startNodeLabelId : this.startScratch = this.nodeLabelCache.get(this.client, startNode, this.startScratch)) {
            if (startNodeLabelId == -1) break;
            this.increment(startNodeLabelId, this.anyRelationshipType, this.anyLabel);
            this.increment(startNodeLabelId, type, this.anyLabel);
            for (int endNodeLabelId : this.endScratch = this.nodeLabelCache.get(this.client, endNode, this.endScratch)) {
                if (endNodeLabelId == -1) break;
                this.increment(startNodeLabelId, this.anyRelationshipType, endNodeLabelId);
                this.increment(startNodeLabelId, type, endNodeLabelId);
            }
        }
        this.endScratch = this.nodeLabelCache.get(this.client, endNode, this.endScratch);
        for (int endNodeLabelId : this.endScratch) {
            if (endNodeLabelId == -1) break;
            this.increment(this.anyLabel, this.anyRelationshipType, endNodeLabelId);
            this.increment(this.anyLabel, type, endNodeLabelId);
        }
    }

    @Override
    public boolean process(RelationshipRecord record) {
        this.process(record.getFirstNode(), record.getType(), record.getSecondNode());
        return false;
    }

    @Override
    public void done() {
        long index = 0L;
        for (int startNodeLabelId = 0; startNodeLabelId <= this.anyLabel; ++startNodeLabelId) {
            for (int typeId = 0; typeId <= this.anyRelationshipType; ++typeId) {
                int endNodeLabelId = 0;
                while (endNodeLabelId <= this.anyLabel) {
                    if (startNodeLabelId == this.anyLabel || endNodeLabelId == this.anyLabel) {
                        int startLabel = startNodeLabelId == this.anyLabel ? -1 : startNodeLabelId;
                        int type = typeId == this.anyRelationshipType ? -1 : typeId;
                        int endLabel = endNodeLabelId == this.anyLabel ? -1 : endNodeLabelId;
                        long count = this.counts.get(index);
                        this.countsUpdater.incrementRelationshipCount(startLabel, type, endLabel, count);
                    }
                    ++endNodeLabelId;
                    ++index;
                }
            }
        }
    }

    public void addCountsFrom(RelationshipCountsProcessor from) {
        long length = this.counts.length();
        for (long i = 0L; i < length; ++i) {
            this.counts.set(i, this.counts.get(i) + from.counts.get(i));
        }
    }
}

