/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionTimespanThreshold;

public class LogPruneStrategyFactory {
    public static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public void prune() {
        }

        public String toString() {
            return "NO_PRUNING";
        }
    };

    static boolean decidePruneForIllegalLogFormat(IllegalLogFormatException e) {
        if (e.wasNewerLogVersion()) {
            throw new RuntimeException("Unable to read database logs, because it contains logs from a newer version of Neo4j.", e);
        }
        return true;
    }

    public static LogPruneStrategy fromConfigValue(FileSystemAbstraction fileSystem, LogFileInformation logFileInformation, PhysicalLogFiles files, LogVersionRepository versionRepo, String configValue) {
        Threshold thresholdToUse;
        String[] tokens = configValue.split(" ");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'");
        }
        String boolOrNumber = tokens[0];
        if (tokens.length == 1) {
            switch (boolOrNumber) {
                case "true": {
                    return NO_PRUNING;
                }
                case "false": {
                    TransactionCountThreshold thresholdToUse2 = new TransactionCountThreshold(1L);
                    return new ThresholdBasedPruneStrategy(fileSystem, logFileInformation, files, versionRepo, thresholdToUse2);
                }
            }
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. The form is 'all' or '<number><unit> <type>' for example '100k txs' " + "for the latest 100 000 transactions");
        }
        String type = tokens[1];
        int number = (int)Config.parseLongWithUnit(boolOrNumber);
        switch (type) {
            case "files": {
                thresholdToUse = new FileCountThreshold(number);
                break;
            }
            case "size": {
                thresholdToUse = new FileSizeThreshold(fileSystem, number);
                break;
            }
            case "txs": {
                thresholdToUse = new TransactionCountThreshold(number);
                break;
            }
            case "hours": {
                thresholdToUse = new TransactionTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.HOURS, number);
                break;
            }
            case "days": {
                thresholdToUse = new TransactionTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.DAYS, number);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. Invalid type '" + type + "', valid are files, size, txs, hours, days.");
            }
        }
        return new ThresholdBasedPruneStrategy(fileSystem, logFileInformation, files, versionRepo, thresholdToUse);
    }
}

