/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.Collection;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV0_19;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV0_20;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV1;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2;

public abstract class CommandReaderFactory {
    public static final DynamicRecordAdder<PropertyBlock> PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyBlock>(){

        @Override
        public void add(PropertyBlock target, DynamicRecord record) {
            record.setCreated();
            target.addValueRecord(record);
        }
    };
    public static final DynamicRecordAdder<Collection<DynamicRecord>> COLLECTION_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<Collection<DynamicRecord>>(){

        @Override
        public void add(Collection<DynamicRecord> target, DynamicRecord record) {
            target.add(record);
        }
    };
    public static final DynamicRecordAdder<PropertyRecord> PROPERTY_DELETED_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyRecord>(){

        @Override
        public void add(PropertyRecord target, DynamicRecord record) {
            assert (!record.inUse()) : record + " is kinda weird";
            target.addDeletedRecord(record);
        }
    };
    public static final DynamicRecordAdder<PropertyKeyTokenRecord> PROPERTY_INDEX_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyKeyTokenRecord>(){

        @Override
        public void add(PropertyKeyTokenRecord target, DynamicRecord record) {
            target.addNameRecord(record);
        }
    };

    public abstract CommandReader newInstance(byte var1, byte var2);

    public static interface DynamicRecordAdder<T> {
        public void add(T var1, DynamicRecord var2);
    }

    public static class Default
    extends CommandReaderFactory {
        private byte lastFormatVersion;
        private byte lastEntryVersion;
        private CommandReader lastReader;

        @Override
        public CommandReader newInstance(byte logFormatVersion, byte logEntryVersion) {
            if (logFormatVersion == this.lastFormatVersion && logEntryVersion == this.lastEntryVersion && this.lastReader != null) {
                return this.lastReader;
            }
            this.lastFormatVersion = logFormatVersion;
            this.lastEntryVersion = logEntryVersion;
            this.lastReader = this.figureOutCorrectReader(logFormatVersion, logEntryVersion);
            return this.lastReader;
        }

        private CommandReader figureOutCorrectReader(byte logFormatVersion, byte logEntryVersion) {
            switch (logEntryVersion) {
                case 0: {
                    switch (logFormatVersion) {
                        case 3: {
                            return new PhysicalLogNeoCommandReaderV0_20();
                        }
                        case 2: {
                            return new PhysicalLogNeoCommandReaderV0_19();
                        }
                    }
                }
                case -2: 
                case -1: {
                    switch (logFormatVersion) {
                        case 4: {
                            return new PhysicalLogNeoCommandReaderV1();
                        }
                        case 5: {
                            return new PhysicalLogNeoCommandReaderV2();
                        }
                    }
                }
            }
            throw new IllegalArgumentException("Unknown log format version (" + logFormatVersion + ") and " + "log entry version (" + logEntryVersion + ")");
        }
    }
}

