/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.util.Collections;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.transaction.log.IOCursor;

public class Cursors {
    public static <T> ResourceIterable<T> iterable(final IOCursor<T> cursor) {
        return new ResourceIterable<T>(){

            @Override
            public ResourceIterator<T> iterator() {
                try {
                    if (cursor.next()) {
                        final Object first = cursor.get();
                        return new ResourceIterator<T>(){
                            T instance;
                            {
                                this.instance = first;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.instance != null;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public T next() {
                                try {
                                    Object t = this.instance;
                                    return t;
                                }
                                finally {
                                    try {
                                        if (cursor.next()) {
                                            this.instance = cursor.get();
                                        } else {
                                            cursor.close();
                                            this.instance = null;
                                        }
                                    }
                                    catch (IOException e) {
                                        this.instance = null;
                                    }
                                }
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void close() {
                                try {
                                    cursor.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        };
                    }
                    cursor.close();
                    return IteratorUtil.asResourceIterator(Collections.emptyIterator());
                }
                catch (IOException e) {
                    return IteratorUtil.asResourceIterator(Collections.emptyIterator());
                }
            }
        };
    }

    public static Cursor countDownCursor(int count) {
        return new CountDownCursor(count);
    }

    public static class CountDownCursor
    implements Cursor {
        private final int count;
        private int current;

        public CountDownCursor(int count) {
            this.count = count;
            this.current = count;
        }

        public boolean next() {
            return this.current-- > 0;
        }

        public void reset() {
            this.current = this.count;
        }

        public void close() {
            this.current = 0;
        }
    }
}

