/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;

public class AutoLoadingCache<E extends EntityWithSizeObject>
extends Cache.Adapter<E> {
    private final Cache<E> actual;
    private final Loader<E> loader;

    public AutoLoadingCache(Cache<E> actual, Loader<E> loader) {
        this.loader = loader;
        this.actual = actual;
    }

    @Override
    public String getName() {
        return this.actual.getName();
    }

    @Override
    public E put(E value, boolean force) {
        return this.actual.put(value, force);
    }

    @Override
    public E remove(long key) {
        return this.actual.remove(key);
    }

    @Override
    public E get(long key) {
        Object result = this.actual.get(key);
        if (result != null) {
            return result;
        }
        result = (EntityWithSizeObject)this.loader.loadById(key);
        if (result == null) {
            return null;
        }
        return this.actual.put(result);
    }

    public E getIfCached(long key) {
        return this.actual.get(key);
    }

    @Override
    public void clear() {
        this.actual.clear();
    }

    @Override
    public long size() {
        return this.actual.size();
    }

    @Override
    public void putAll(Collection values) {
        this.actual.putAll(values);
    }

    @Override
    public long hitCount() {
        return this.actual.hitCount();
    }

    @Override
    public long missCount() {
        return this.actual.missCount();
    }

    @Override
    public void updateSize(E entity, int newSize) {
        this.actual.updateSize(entity, newSize);
    }

    @Override
    public void printStatistics() {
        this.actual.printStatistics();
    }

    public static interface Loader<E> {
        public E loadById(long var1);
    }
}

