/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.exceptions.index.ExceptionDuringFlipKernelException;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;

public class FlippableIndexProxy
implements IndexProxy {
    private volatile boolean closed;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile IndexProxyFactory flipTarget;
    private volatile IndexProxy delegate;

    public FlippableIndexProxy() {
        this(null);
    }

    public FlippableIndexProxy(IndexProxy originalDelegate) {
        this.delegate = originalDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.start();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        this.lock.readLock().lock();
        try {
            LockingIndexUpdater lockingIndexUpdater = new LockingIndexUpdater(this.delegate.newUpdater(mode));
            return lockingIndexUpdater;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> drop() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.drop();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.force();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDescriptor getDescriptor() {
        this.lock.readLock().lock();
        try {
            IndexDescriptor indexDescriptor = this.delegate.getDescriptor();
            return indexDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        this.lock.readLock().lock();
        try {
            SchemaIndexProvider.Descriptor descriptor = this.delegate.getProviderDescriptor();
            return descriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalIndexState getState() {
        this.lock.readLock().lock();
        try {
            InternalIndexState internalIndexState = this.delegate.getState();
            return internalIndexState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.close();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        this.lock.readLock().lock();
        try {
            IndexReader indexReader = this.delegate.newReader();
            return indexReader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        IndexProxy proxy;
        do {
            this.lock.readLock().lock();
            proxy = this.delegate;
            this.lock.readLock().unlock();
        } while (proxy.awaitStoreScanCompleted());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() throws IndexActivationFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.delegate.activate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() throws IndexPopulationFailedKernelException, ConstraintVerificationFailedKernelException {
        this.lock.readLock().lock();
        try {
            this.delegate.validate();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        this.lock.readLock().lock();
        try {
            ResourceIterator<File> resourceIterator = this.delegate.snapshotFiles();
            return resourceIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        this.lock.readLock().lock();
        try {
            IndexPopulationFailure indexPopulationFailure = this.delegate.getPopulationFailure();
            return indexPopulationFailure;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlipTarget(IndexProxyFactory flipTarget) {
        this.lock.writeLock().lock();
        try {
            this.flipTarget = flipTarget;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flipTo(IndexProxy targetDelegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = targetDelegate;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(Callable<Void> actionDuringFlip, FailedIndexProxyFactory failureDelegate) throws FlipFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.assertStillOpenForBusiness();
            try {
                actionDuringFlip.call();
                this.delegate = this.flipTarget.create();
            }
            catch (Exception e) {
                this.delegate = failureDelegate.create(e);
                throw new ExceptionDuringFlipKernelException(e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexConfiguration config() {
        this.lock.readLock().lock();
        try {
            IndexConfiguration indexConfiguration = this.delegate.config();
            return indexConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.delegate + "[target:" + this.flipTarget + "]";
    }

    private void assertStillOpenForBusiness() throws IndexProxyAlreadyClosedKernelException {
        if (this.closed) {
            throw new IndexProxyAlreadyClosedKernelException(this.getClass());
        }
    }

    private class LockingIndexUpdater
    extends DelegatingIndexUpdater {
        private LockingIndexUpdater(IndexUpdater delegate) {
            super(delegate);
            FlippableIndexProxy.this.lock.readLock().lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
            try {
                this.delegate.close();
            }
            finally {
                FlippableIndexProxy.this.lock.readLock().unlock();
            }
        }
    }
}

