/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class ProducerStep<BATCH>
extends AbstractStep<Void> {
    protected final int batchSize;

    public ProducerStep(StageControl control, String name, int batchSize, int movingAverageSize) {
        super(control, name, movingAverageSize, new StatsProvider[0]);
        this.batchSize = batchSize;
    }

    @Override
    public long receive(long ticket, Void batch) {
        new Thread("PRODUCER"){

            @Override
            public void run() {
                ProducerStep.this.assertHealthy();
                try {
                    ProducerStep.this.process();
                    ProducerStep.this.endOfUpstream();
                }
                catch (Throwable e) {
                    ProducerStep.this.issuePanic(e, false);
                }
            }
        }.start();
        return 0L;
    }

    protected void process() {
        Object batch = null;
        long startTime = System.currentTimeMillis();
        while ((batch = this.nextBatchOrNull(this.batchSize)) != null) {
            this.totalProcessingTime.add(System.currentTimeMillis() - startTime);
            this.sendDownstream(this.doneBatches.incrementAndGet(), batch);
            this.assertHealthy();
            startTime = System.currentTimeMillis();
        }
    }

    protected abstract Object nextBatchOrNull(int var1);
}

