/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class IdMapperPreparationStep
extends LonelyProcessingStep {
    private final IdMapper idMapper;
    private final InputIterable<Object> allIds;

    public IdMapperPreparationStep(StageControl control, int batchSize, int movingAverageSize, IdMapper idMapper, InputIterable<Object> allIds, StatsProvider memoryUsageStats) {
        super(control, "", batchSize, movingAverageSize, memoryUsageStats);
        this.idMapper = idMapper;
        this.allIds = allIds;
    }

    @Override
    protected void process() {
        this.idMapper.prepare(this.allIds, new ProgressListener.Adapter(){

            @Override
            public void started(String task) {
                IdMapperPreparationStep.this.resetStats();
                IdMapperPreparationStep.this.changeName(task);
            }

            @Override
            public void set(long progress) {
                throw new UnsupportedOperationException("Shouldn't be required");
            }

            @Override
            public void failed(Throwable e) {
                IdMapperPreparationStep.this.issuePanic(e);
            }

            @Override
            public synchronized void add(long progress) {
                IdMapperPreparationStep.this.progress(progress);
            }

            @Override
            public void done() {
            }
        });
    }
}

