/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.lang.reflect.Field;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import sun.misc.Unsafe;

abstract class OffHeapNumberArray
implements NumberArray {
    protected final long address;
    protected final long length;
    protected final int shift;
    protected final int stride;
    private boolean closed;
    protected static final Unsafe unsafe = OffHeapNumberArray.getUnsafe();

    protected OffHeapNumberArray(long length, int shift) {
        this.length = length;
        this.shift = shift;
        this.stride = 1 << shift;
        this.address = unsafe.allocateMemory(length << shift);
    }

    @Override
    public long length() {
        return this.length;
    }

    protected long addressOf(long index) {
        if (index < 0L || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Requested index " + index + ", but length is " + this.length);
        }
        return this.address + (index << this.shift);
    }

    protected boolean isByteUniform(long value) {
        byte any = 0;
        for (int i = 0; i < this.stride; ++i) {
            byte test = (byte)(value >>> 8 * i);
            if (i == 0) {
                any = test;
                continue;
            }
            if (test == any) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length * (long)this.stride);
    }

    private static Unsafe getUnsafe() {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            return (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            unsafe.freeMemory(this.address);
            this.closed = true;
        }
    }
}

