/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.SourceInputIterator;

public class Utils {
    public static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if (value > 32767L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if (value > 127L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (byte)value;
    }

    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return !(dataA < dataB ^ dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
        }
        return false;
    }

    public static InputIterable<Object> idsOf(final InputIterable<InputNode> nodes) {
        return new InputIterable<Object>(){

            @Override
            public InputIterator<Object> iterator() {
                final InputIterator iterator = nodes.iterator();
                return new SourceInputIterator<Object, InputNode>(iterator){

                    @Override
                    public void close() {
                        iterator.close();
                    }

                    @Override
                    protected Object fetchNextOrNull() {
                        return iterator.hasNext() ? ((InputNode)iterator.next()).id() : null;
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return false;
            }
        };
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

