/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;

public class RelationshipLinkbackProcessor
implements RecordProcessor<RelationshipRecord> {
    private final NodeRelationshipLink nodeRelationshipLink;

    public RelationshipLinkbackProcessor(NodeRelationshipLink nodeRelationshipLink) {
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    public boolean process(RelationshipRecord record) {
        boolean isLoop;
        boolean bl = isLoop = record.getFirstNode() == record.getSecondNode();
        if (isLoop) {
            long prevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getFirstNode(), record.getType(), Direction.BOTH, record.getId(), false);
            if (prevRel == -1L) {
                record.setFirstInFirstChain(true);
                record.setFirstInSecondChain(true);
                prevRel = this.nodeRelationshipLink.getCount(record.getFirstNode(), record.getType(), Direction.BOTH);
            }
            record.setFirstPrevRel(prevRel);
            record.setSecondPrevRel(prevRel);
        } else {
            long firstPrevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getFirstNode(), record.getType(), Direction.OUTGOING, record.getId(), false);
            if (firstPrevRel == -1L) {
                record.setFirstInFirstChain(true);
                firstPrevRel = this.nodeRelationshipLink.getCount(record.getFirstNode(), record.getType(), Direction.OUTGOING);
            }
            record.setFirstPrevRel(firstPrevRel);
            long secondPrevRel = this.nodeRelationshipLink.getAndPutRelationship(record.getSecondNode(), record.getType(), Direction.INCOMING, record.getId(), false);
            if (secondPrevRel == -1L) {
                record.setFirstInSecondChain(true);
                secondPrevRel = this.nodeRelationshipLink.getCount(record.getSecondNode(), record.getType(), Direction.INCOMING);
            }
            record.setSecondPrevRel(secondPrevRel);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

