/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRelationshipRecordsBackwardsStep
extends IoProducerStep<NodeRecord[]> {
    private final RelationshipStore store;
    private final long highId;
    private long id;

    public ReadRelationshipRecordsBackwardsStep(StageControl control, int batchSize, int movingAverageSize, RelationshipStore store) {
        super(control, batchSize, movingAverageSize);
        this.store = store;
        this.highId = this.id = store.getHighId();
    }

    @Override
    protected Object nextBatchOrNull(int batchSize) {
        int size = (int)Math.min((long)batchSize, this.id);
        RelationshipRecord[] batch = new RelationshipRecord[size];
        RelationshipRecord next = new RelationshipRecord(-1L);
        for (int i = 0; i < size; ++i) {
            if (!this.store.fillRecord(--this.id, next, RecordLoad.CHECK)) continue;
            batch[i] = next;
            next = new RelationshipRecord(-1L);
        }
        return size > 0 ? batch : null;
    }

    @Override
    protected long position() {
        return (this.highId - this.id) * 34L;
    }
}

